<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

class EmailConfig
{

    public static function setMailConfig($sendFrom)
    {

        //Get the data from settings table
        $settings = (object)[];


        if ($sendFrom['reseller'] !=null) {

             $settings = DB::table('mail_settings')->where('reseller_id',$sendFrom['reseller'])->first();
        } elseif ($sendFrom['admin'] !=null) {
             $settings = DB::table('mail_settings')->where('admin_id', $sendFrom['admin'])->first();
        }

        if (!empty($settings)) {
            //Set the data in an array variable from settings table
            $mailConfig = [
                'transport' => $settings->mail_driver,
                'host' => $settings->mail_host,
                'port' => $settings->mail_port,
                'encryption' => $settings->mail_encryption,
                'username' => $settings->mail_username,
                'password' => $settings->mail_password,
                'from' => [
                    'address' => $settings->mail_from_address,
                    'name' => $settings->mail_from_name,
                ],
                'timeout' => null
            ];
            //config(['mail.mailers.smtp' => $mailConfig]);
            Config::set('mail.mailers.smtp', $mailConfig);
     
        } 


        //To set configuration values at runtime, pass an array to the config helper
        
    }
}
