<?php

namespace App\Helpers;

class SshConnect
{
    private $host = 'host';
    private $user = 'user';
    private $port = '22';
    private $password = 'password';
    private $con = null;
    private $shell_type = 'xterm';
    private $shell = null;
    private $error_log = '';
    private $output = '';

    function __construct($host, $port)
    {
        $this->host = $host;
        $this->port = $port;
    }

    function connect()
    {
        if (function_exists('ssh2_connect')) {
            $this->con  = ssh2_connect($this->host, $this->port);
            if (!$this->con) {
                $this->error_log = "Connection failed !\n";
            }
        } else {
            $this->error_log .= "SSH Connect Function Not Exist \n";
        }
        return $this;
    }

    function keyConnect()
    {
        $this->con = ssh2_connect($this->host, $this->port);

        if (ssh2_auth_pubkey_file(
            $this->con,
            'root',
            'C:\laragon\www\MailConeApp\id_rsa.pub','C:\laragon\www\MailConeApp\id_rsa',''

        )) {
            $this->error_log .= "Public Key Authentication Successful \n";

        } else {
            $this->error_log .='Public Key Authentication Failed';
        }
        return $this;
    }

    function sshAuth($user, $password)
    {
        $this->user = $user;
        $this->password = $password;

        if (!ssh2_auth_password($this->con, $this->user, $this->password)) {
            $this->error_log .= "Authorization failed ! \n";
        }
        return $this;
    }

    function commandExec($command = '')
    {
        $comExec = ssh2_exec($this->con,  $command);
        if (!$comExec) {
            $this->error_log .= "Server connection failed ! \n";
        } else {
            $commandError = ssh2_fetch_stream($comExec, SSH2_STREAM_STDERR);
            // Enable blocking for both streams
            stream_set_blocking($commandError, true);
            stream_set_blocking($comExec, true);
            $this->output
                = stream_get_contents($comExec);
            $this->error_log .= stream_get_contents($commandError);

            // Close the streams
            fclose($commandError);
            fclose($comExec);
        }

        return $this;
    }

    function getResult()
    {
        $result['error'] = $this->error_log;
        $result['success'] = $this->output;
        $result['fingerprint'] = $this->fingerprint();
        return $result;
    }

    function fingerprint()
    {
        return ssh2_fingerprint($this->con, SSH2_FINGERPRINT_MD5 | SSH2_FINGERPRINT_HEX);
    }

    function disconnect()
    {
        return ssh2_disconnect($this->con);
    }
}//End of the class
