<?php

namespace App\Helpers\Traits;

trait ClientTraits
{
    function getClientsProducts(int $clientId)
    {
        $formPost['action']='GetClientsProducts';
        $formPost['responsetype']='json';
        $formPost['clientid']=$clientId;
        $this->formFields = $formPost;
        return $this;
    }

    function getClientsDomains(int $clientId)
    {
        $formPost['action']='GetClientsDomains';
        $formPost['clientid']=$clientId;
        $formPost['responsetype']='json';
        $this->formFields = $formPost;
        return $this;
    }

    function getClientsProdutDetails($serviceid)
    {
        $formPost['action']='GetClientsProducts';
        $formPost['responsetype']='json';
        $formPost['serviceid']=$serviceid;
        $this->formFields = $formPost;
        return $this;
    }

    function productSuspend($serviceId,$reason){
        $formPost['action']='ModuleSuspend';
        $formPost['suspendreason']=$reason;
        $formPost['responsetype']='json';
        $formPost['serviceid']=$serviceId;
        $this->formFields = $formPost;
        return $this;
    }

    function productUnsuspend($serviceId){
        $formPost['action']='ModuleUnsuspend';
        $formPost['responsetype']='json';
        $formPost['serviceid']=$serviceId;
        $this->formFields = $formPost;
        return $this;
    }

    function productChangePwd($serviceId,$password){
        $formPost['action']='ModuleChangePw';
        $formPost['serviceid']=$serviceId;
        $formPost['servicepassword']=$password;
        $formPost['responsetype']='json';
        $this->formFields = $formPost;
        return $this;
    }

    function productCreate($serviceId){
        $formPost['action']='ModuleCreate';
        $formPost['serviceid']=$serviceId;
        $formPost['responsetype']='json';
        $this->formFields = $formPost;
        return $this;
    }

    function productTerminate($serviceId){
        $formPost['action']='ModuleTerminate';
        $formPost['serviceid']=$serviceId;
        $formPost['responsetype']='json';
        $this->formFields = $formPost;
        return $this;
    }

}
