<?php

namespace App\Helpers\Traits;

trait SupportTraits
{

    /**=======  allTickets retrive all active ticket from the portal ============ */
    function allTickets()
    {
        $formPost = array(
            'action' => 'GetTickets',
            'limitstart'=>0,
            'limitnum'=>0,
            'status'=>'All Active Tickets',
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }

    /**=======  getTicket retrive single Ticket by Ticket Number from the portal ============ */
    function getTicket($tiketid){
        $formPost = array(
            'action' => 'GetTicket',
            'ticketid' => $tiketid,
            'repliessort'=>'desc',
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }

    /**=======  postTicketReply for make reply to the client ============ */
    function postTicketReply($formData){
        $formPost = array(
            'action' => 'AddTicketReply',
            'markdown' => true,
            'attachments' => base64_encode(json_encode([['name' => 'sample_text_file.txt', 'data' => base64_encode('This is a sample text file contents')]])),
            'responsetype' => 'json',
        );

        $this->formFields = array_merge($formData,$formPost);
        return $this;
    }

     /**=======  postTicketReply for make reply to the client ============ */
     function postTicketReplyUpdate($formData){
        $formPost = array(
            'action' => 'UpdateTicket',
            'markdown' => true,
            'responsetype' => 'json',
        );

        $this->formFields = array_merge($formData,$formPost);
        return $this;
    }
 /**=======  note  for make reply note for admins ============ */
    function ticketReplyNote($formData){
        $formPost = array(
            'action' => 'AddTicketNote',
            'markdown' => true,
            'responsetype' => 'json',
        );

        $this->formFields = array_merge($formData,$formPost);
        return $this;
    }
    /**=======  getTicketCounts retrive history of Ticket how many tickets in multiple stage from the portal ============ */
    function getTicketCounts(){
        $formPost = array(
            'action' => 'GetTicketCounts',
            'ignoreDepartmentAssignments' => false,
            'includeCountsByStatus' => true,
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }

      /**=======  getTicketCounts retrive history of Ticket how many tickets in multiple stage from the portal ============ */
    function getTicketNote($ticketid)
    {
        $formPost = array(
            'action' => 'GetTicketNotes',
           'ticketid'=>$ticketid,
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }


    function getSupportStatuses()
    {
        $formPost = array(
            'action' => 'GetSupportStatuses',
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }

    function getSupportDepartments()
    {
        $formPost = array(
            'action' => 'GetSupportDepartments',
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }

    function getServers()
    {
        $formPost = array(
            'action' => 'myservers',
            'responsetype' => 'json',
        );

        $this->formFields = $formPost;
        return $this;
    }
}
