<?php

namespace App\Helpers;
use App\Helpers\Traits\SupportTraits;
use App\Helpers\Traits\UsersTraits;
use App\Helpers\Traits\ClientTraits;

class WhmcsProcessor
{
    private $host;
    private $user;
    private $pass;
    private $formFields;
    private $response;
    private $httpResponse;
    private $company;

    use SupportTraits,UsersTraits,ClientTraits;

    function whmcsConnect(string $host,string $user,string $password,$company){
        $this->host = $host;
        $this->user = $user;
        $this->pass = $password;
        $this->company=$company;
        return $this;
    }


    function makeRequest()
    {

        $postField = $this->formFields;
        $postField['username'] = $this->user;
        $postField['password'] = $this->pass;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->host . 'includes/api.php');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0); //this is waiting time how much time wait for connection
        curl_setopt($ch, CURLOPT_TIMEOUT, 10); //timeout in seconds
        curl_setopt(
            $ch,
            CURLOPT_POSTFIELDS,
            http_build_query(
                $postField
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
        $httpResponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->response = $response;
        $this->httpResponse = $httpResponse;
        return $this;
    }

    function getResult()
    {
        $result['http_code'] = $this->httpResponse;
        $result['response'] = $this->response;
        $result['company']=$this->company;
        return $result;
    }

}
