<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Models\AdminLoginModel;
use App\Models\Company\CompanyModel;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AdminAuthController extends Controller
{
    use ApiResponseTrait;

    public function getToken(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'username' => 'required',
            'password' => 'required'
        ]);
        if ($validation->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Username and password required'
            ], 201);
        }

        $user = AdminLoginModel::where('admin_email', $request->username)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json([
                'status' => 'error',
                'message' => 'Login Failed Try Again'
            ], 201);
        }

        $token = $user->createToken($request->email.time())->plainTextToken;
        return response()->json([
            'status' => 'success',
            'user' => $user,
            'authorisation' => [
                'token' => $token,
                'type' => 'bearer',
            ]
        ], 200);
    }

    public function destroyToken(Request $request)
    {
        $user=Auth::user();
        return response()->json(['data'=>$user]);
    }
}
