<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AgentAuthController extends Controller
{
    use ApiResponseTrait;

    public function getToken(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'username' => 'required',
            'password' => 'required'
        ]);
        if ($validation->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Username and password required'
            ], 201);
        }

        $user = User::where('user_name', $request->username)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json([
                'status' => 'error',
                'message' => 'Login Failed Try Again'
            ], 201);
        }

        $token = $user->createToken($request->email.time(),['web'])->plainTextToken;
        return response()->json([
            'status' => 'success',
            'user' => $user,
            'authorisation' => [
                'token' => $token,
                'type' => 'bearer',
            ]
        ], 200);
    }

    public function destroyToken()
    {
       // Auth::user()->currentAccessToken()->delete();
        return $this->successResponse('Successfully Deleted', '', 200);
    }
}
