<?php

namespace App\Http\Controllers\APIs\AgentsJob;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyModel;
use Illuminate\Http\Request;
use App\Helpers\WhmcsProcessor;
use App\Models\UserActivityLogModel;
use Illuminate\Support\Facades\DB;
use App\Traits\ApiResponseTrait;

class ApiTickets extends Controller
{
    use ApiResponseTrait;
    function index()
    {
        abort(404);
        $tickets = array();
        $whmcs = new WhmcsProcessor();
        $userCompany = json_decode(Auth()->user()->user_company, true);
        $com = CompanyModel::find(1);
        // foreach ($company as $com) {
        //     //$tickets[] = $whmcs->whmcsConnect($com->company_url,$com->company_identifier,$com->company_secret)->allTikets()->makeRequest()->getResult();
        //     //$tickets[] = $whmcs->whmcsConnect($com->company_url,$com->company_identifier,$com->company_secret)->getSupportStatuses()->makeRequest()->getResult();
        //     //$tickets[] = $whmcs->whmcsConnect($com->company_url,$com->company_identifier,$com->company_secret)->getSupportDepartments()->makeRequest()->getResult();
        //     //$tickets[] = $whmcs->whmcsConnect($com->company_url,$com->company_identifier,$com->company_secret)->getTicket('555143')->makeRequest()->getResult();
        //     //$tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getTicketCounts()->makeRequest()->getResult();
        //     $tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getUsers()->makeRequest()->getResult();
        // }
        $tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getServers()->makeRequest()->getResult();
        echo "<pre>";
        print_r(json_decode($tickets[0]['response'], true));
    }

    function allTicket()
    {

        $tickets = array();
        $whmcs = new WhmcsProcessor();
        $userCompany = json_decode(Auth()->user()->user_company, true);
        $company = CompanyModel::whereIn('company_id', $userCompany)->get();
        foreach ($company as $com) {
            $tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->allTickets()->makeRequest()->getResult();
        }
        $result['company'] = $company;
        $result['tickets'] = $tickets;
        return $this->successResponse('', $result, 200);
    }

    function ticketPending()
    {

        $tickets = array();
        $whmcs = new WhmcsProcessor();
        $userCompany = json_decode(Auth()->user()->user_company, true);
        $company = CompanyModel::whereIn('company_id', $userCompany)->get();
        foreach ($company as $com) {
            $tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->allTickets()->makeRequest()->getResult();
        }

        $result['company'] = $company;
        $result['tickets'] = $tickets;
        return $this->successResponse('', $result, 200);
    }

    function ticketReply($tid = '', $client = '', $company = '')
    {

        $clientProducts = '';
        $clientDomains = '';
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($company);
        $company=$com;
        $tickets = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->getTicket($tid)->makeRequest()->getResult();

        if ($client != 0) {
            $clientProducts = cache()->remember('clientproduct_' . $company . '_' . $client, now()->addMinutes(60), function () use ($whmcs, $com, $company, $client) {
                return $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->getClientsProducts($client)->makeRequest()->getResult();
            });
            $clientDomains = cache()->remember('clientdomain_' . $company . '_' . $client, now()->addMinutes(60), function () use ($whmcs, $com, $company, $client) {
                return $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->getClientsDomains($client)->makeRequest()->getResult();
            });
        }

        $status = cache()->remember('status' . $company, now()->addHours(720), function () use ($whmcs, $com, $company) {
            return $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->getSupportStatuses()->makeRequest()->getResult();
        });
        $department = cache()->remember('department' . $company, now()->addHours(720), function () use ($whmcs, $com, $company) {
            return $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->getSupportDepartments()->makeRequest()->getResult();
        });

        return $this->successResponse('', compact('tickets', 'status', 'company', 'clientProducts', 'clientDomains', 'department', 'client'), 200);
    }

    /**================ Ticket Note and Ticket Reply Get Using Json ============= */

    function getJsonNoteReply(Request $request)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($request->company);
        $tickets = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getTicket($request->tid)->makeRequest()->getResult();
        $ticketsNote = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getTicketNote($request->tid)->makeRequest()->getResult();
        $result['tickets'] = $tickets;
        $result['ticketsNote'] = $ticketsNote;
        $this->successResponse('',$result,200);
    }

    /**================ End Ticket Note and Ticket Reply Get Using Json ============= */

    function postTicketReply($tid = '', $company = '', Request $request)
    {
        $request->validate([
            'message' => 'required',
            'status' => 'required',
            'attachment' => 'nullable|max:5000'
        ]);

        $agentName = DB::table('user_details')->where('user_ids', Auth()->guard('web')->user()->user_id)->first();

        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($company);
        $formPost['message'] = strip_tags(strip_tags(str_replace('&nbsp;', ' ', $request->message))) . "\r\n \r\n" . Auth()->guard('web')->user()->user_signature . "\r\n \r\n" . $com->company_signature;
        $formPost['ticketid'] = $tid;
        $formPost['adminusername'] = $agentName->user_fullname;

        $replyUpdate['ticketid'] = $tid;
        $replyUpdate['priority'] = $request->priority;
        $replyUpdate['status'] = $request->status;
        $replyUpdate['deptid'] = $request->department;
        $tickets = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->postTicketReply($formPost)->makeRequest()->getResult();
        $ticketsUpdate = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->postTicketReplyUpdate($replyUpdate)->makeRequest()->getResult();

        $log = new UserActivityLogModel();
        $log->log_date = date('Y-m-d H:i:s');
        $log->log_details = json_encode($formPost);
        $log->user_id = Auth()->user()->user_id;
        $log->log_type = 'Ticket Reply';
        $log->company_ids = $company;
        $log->save();

        $response = json_decode($tickets['response'], true);
        Cache()->forget('t' . $tid);
        if ($response['result'] == 'success') {
            $this->successResponse('Reply Successfully Send');
        } else {
            return $this->errorResponse($response['message'], 422);
        }
    }

    function updateTicketStatus(Request $request)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($request->company);
        $replyUpdate['ticketid'] = $request->tid;

        $replyUpdate['status'] = $request->status;
        $ticketsUpdate = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->postTicketReplyUpdate($replyUpdate)->makeRequest()->getResult();

        $log = new UserActivityLogModel();
        $log->log_date = date('Y-m-d H:i:s');
        $log->log_details = json_encode($replyUpdate);
        $log->user_id = Auth()->user()->user_id;
        $log->log_type = 'Ticket Update';
        $log->company_ids = $com->company_id;
        $log->save();

        $response = json_decode($ticketsUpdate['response'], true);

        if ($response['result'] == 'success') {
            return $this->successResponse('Successfully Updated', null, 200);
        } else {
            return $this->errorResponse($response['message'], 422);
        }
    }

    function ClosedTicketStatus($tid = '', $company = '')
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($company);
        $replyUpdate['ticketid'] = $tid;
        $replyUpdate['status'] = 'Closed';

        $ticketsUpdate = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->postTicketReplyUpdate($replyUpdate)->makeRequest()->getResult();

        $log = new UserActivityLogModel();
        $log->log_date = date('Y-m-d H:i:s');
        $log->log_details = json_encode($replyUpdate);
        $log->user_id = Auth()->guard('web')->user()->user_id;
        $log->log_type = 'Ticket Update';
        $log->company_ids = $com->company_id;
        $log->save();

        $response = json_decode($ticketsUpdate['response'], true);
        if ($response['result'] == 'success') {
            return back()->with('success', 'Ticket Successfully Closed');
        } else {
            return back()->with('error', $response['message']);
        }
    }

    function ticketReplyNote($tid = '', $company = '', Request $request)
    {
        $request->validate([
            'notemessage' => 'required',
        ]);

        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::find($company);
        $formPost['message'] = strip_tags(strip_tags($request->notemessage));
        $formPost['ticketid'] = $tid;


        $tickets = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $company)->ticketReplyNote($formPost)->makeRequest()->getResult();
        $response = json_decode($tickets['response'], true);
        if ($response['result'] == 'success') {
            return back()->with('success', 'Note Reply Successfully Send');
        } else {
            return back()->with('error', $response['message']);
        }
    }

    function ticketCounts()
    {
        $tickets = array();
        $whmcs = new WhmcsProcessor();
        $company = CompanyModel::all();
        foreach ($company as $com) {
            $tickets[] = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getTicketCounts()->makeRequest()->getResult();
        }
        return view('agentsjob.tickets.counts', compact('tickets', 'company'));
    }

    function AutoLogin()
    {
        //this function will work for auto login;
    }
}
