<?php

namespace App\Http\Controllers\APIs\AgentsJob;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Company\CompanyModel;
use App\Helpers\WhmcsProcessor;

class Clients extends Controller
{
    function productDetails($serviceId, $company)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->getClientsProdutDetails($serviceId)->makeRequest()->getResult();
        return view('agentsjob.client.product_details', compact('productDetails', 'company'));
    }

    function productSuspend($serviceId, $company, $reason = '')
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->productSuspend($serviceId, $reason)->makeRequest()->getResult();
        $data = json_decode($productDetails['response'], true);
        if ($data['result'] == 'success') {
            session()->flash('success', 'Service Successfully Suspended');
        } else {
            session()->flash('error', @$data['message']);
        }
        return response()->json($productDetails);
    }
    function productUnsuspend($serviceId, $company)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->productUnsuspend($serviceId)->makeRequest()->getResult();
        $data = json_decode($productDetails['response'], true);
        if ($data['result'] == 'success') {
            return back()->with('success', 'Service Successfully Unsuspended');
        } else {
            return back()->with('error', @$data['message']);
        }
    }

    function productChangePwd($serviceId, $company, $password = '')
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->productChangePwd($serviceId, $password)->makeRequest()->getResult();
        $data = json_decode($productDetails['response'], true);
        if ($data['result'] == 'success') {
            session()->flash('success', 'Password Successfully Changed');
        } else {
            session()->flash('error', @$data['message']);
        }
        return response()->json($productDetails);
    }

    function productCreate($serviceId, $company)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->productCreate($serviceId)->makeRequest()->getResult();
        ///print_r($productDetails);
        $data = json_decode($productDetails['response'], true);
        if (@$data['result'] == 'success') {
            return back()->with('success', 'Service Successfully Created');
        } else {
            return back()->with('error', @$data['message']);
        }
    }

    function productTerminate($serviceId, $company)
    {
        $whmcs = new WhmcsProcessor();
        $com = CompanyModel::where('company_id', $company)->first();
        $productDetails = $whmcs->whmcsConnect($com->company_url, $com->company_identifier, $com->company_secret, $com->company_id)->productTerminate($serviceId)->makeRequest()->getResult();
        ///print_r($productDetails);
        $data = json_decode($productDetails['response'], true);
        if (@$data['result'] == 'success') {
            return back()->with('success', 'Service Successfully Terminated');
        } else {
            return back()->with('error', @$data['message']);
        }
    }
}
