<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use ZipArchive;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class AddonControl extends Controller
{
    function index()
    {
        return view('plugins');
    }

    function uploadTemplate(){
        return view('template');
    }

    public function store(Request $request)
    {

        if (class_exists('ZipArchive')) {
            if ($request->hasFile('addon_zip')) {
                $upload_dir = 'addons'; //directory where plugins will upload /public/addons
                (!is_dir($upload_dir)) ? mkdir($upload_dir, 0777, true) : null;
                $path = Storage::disk('public_root')->put($upload_dir, $request->addon_zip);
                $zipped_file_name = $request->addon_zip->getClientOriginalName(); //Uploaded File Original Name Before Upload

                $zipFile = new ZipArchive(); // Zip Class Call for process zip files
                $zipOpen = $zipFile->open(base_path('public/' . $path));

                $random_dir = Str::random(10);
                $unzip_directory = 'temporary/'; //where temporary Unzip file

                $getOriginalName = trim($zipFile->getNameIndex(0), '/'); // This function call first folder after extract Zip file

                if ($zipOpen === true) {
                    $zipFile->extractTo(base_path($unzip_directory . $random_dir . '/' . $upload_dir));
                    $zipFile->close();
                } else {
                    echo "File Not Open";
                    exit;
                }

                $str = file_get_contents(base_path($unzip_directory . $random_dir . '/' . $upload_dir . '/config.json'));
                $json = json_decode($str, true);

                if (!empty($json['directory_required'])) {
                    foreach ($json['directory_required'][0]['name'] as $newDir) {
                        if (!is_dir(base_path($newDir))) {
                            if (!mkdir(base_path($newDir), 0777, true)) {
                                echo "Unable To Make Directory";
                            }
                        }
                    }
                }

                if (!empty($json['files'])) {
                    foreach ($json['files'] as $file) {
                        copy(base_path($unzip_directory . $random_dir . '/' . $file['file_source']), base_path($file['file_destination']));
                    }
                }



                $sql_path = base_path($unzip_directory . $random_dir . '/' . $json['sql_file']);

                if (file_exists($sql_path)) {
                    DB::unprepared(file_get_contents($sql_path));
                }

                //$folderName=explode('.',$json['plugin_name']);

                //rename(base_path($unzip_directory. $random_dir), base_path($unzip_directory.$folderName[0]));//Rename folder name

                $this->delTree(base_path($unzip_directory)); //Remove Temporary Directory
                $this->delTree(base_path('public/' . $upload_dir)); // Remove Addon Directory After Complete Process
                to_route('plugins_upload')->with('success', 'Successfully Plugins Uploaded');
            } else {
                to_route('plugins_upload')->with('error', 'Zip File Is Required');
            }
        } else {
            to_route('plugins_upload')->with('error', 'ZIP Function Not Enabled');
        }
    }

    function delTree($dir)
    {
        $files = array_diff(scandir($dir), array('.', '..'));

        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? $this->delTree("$dir/$file") : unlink("$dir/$file");
        }

        return rmdir($dir);
    }

    function templateUpload(Request $request)
    {

        $upload_dir = 'addons'; //directory where plugins will upload /public/addons
        (!is_dir($upload_dir)) ? mkdir($upload_dir, 0777, true) : null;
        $path = Storage::disk('public_root')->put($upload_dir, $request->addon_zip);
        $zipped_file_name = $request->addon_zip->getClientOriginalName(); //Uploaded File Original Name Before Upload

        $zipFile = new ZipArchive(); // Zip Class Call for process zip files
        $zipOpen = $zipFile->open(base_path('public/' . $path));

        $random_dir = Str::random(10);
        $unzip_directory = 'temporary/'; //where temporary Unzip file

        $getOriginalName = trim($zipFile->getNameIndex(0), '/'); // This function call first folder after extract Zip file

        if ($zipOpen === true) {
            $zipFile->extractTo(base_path($unzip_directory . $random_dir . '/' . $upload_dir));
            $zipFile->close();
        } else {
            echo "File Not Open";
            exit;
        }

        $str = file_get_contents(base_path($unzip_directory . $random_dir . '/' . $upload_dir . '/config.json'));
        $json = json_decode($str, true);

        if (!empty($json['directory_required'])) {
            foreach ($json['directory_required'] as $newDir) {
                $this->copyToFolder(base_path($unzip_directory . $random_dir . '/' . $upload_dir . '/' . $newDir['source'][0]), base_path($newDir['name'][0]));
            }
        }

        $this->delTree(base_path($unzip_directory)); //Remove Temporary Directory After Complete Process
        $this->delTree(base_path('public/' . $upload_dir)); // Remove Addon Directory After Complete Process
        echo "Done";
    }

    function copyToFolder($src, $dst)
    {

        if (is_dir($src)) {

            if (!is_dir($dst)) {
                mkdir($dst);
            }

            $files = scandir($src);
            foreach ($files as $file) {
                if ($file != "." && $file != "..") {
                    $this->copyToFolder("$src/$file", "$dst/$file");
                }
            }
        } else if (file_exists($src)) {
            copy($src, $dst);
        } else {
            echo "this is not a folder <br/>";
        }
        return true;
    }
}
