<?php

namespace App\Http\Controllers;

use App\Mail\PasswordReset;
use Illuminate\Http\Request;
use App\Models\AdminLoginModel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;

class AdminLogin extends Controller
{
    function index()
    {
        //return Auth::getRecallerName();//get cookie for remember
        // if (Auth::guard('admin')->check() || Auth::guard('admin')->viaRemember()) {
        //     return redirect()->route('dashboard');
        // } else {
        //     return view('adminlogin.login');
        // }

        return view('adminlogin.login');
    }

    function checkLogin(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required'
        ]);
        $user = AdminLoginModel::where('admin_email', $request->username)->first();

        if (!empty($user) && Hash::check($request->password, $user->password)) {
            Auth::guard('admin')->login($user, $request->remember_me);
            return redirect()->route('dashboard');
        } else {
            return redirect()->back()->with('failed', 'User name or password wrong');
        }
    }

    function forgetPassword()
    {
        return view('adminlogin.forgetpassword');
    }

    function sendResetEmail(Request $request)
    {
       $user = AdminLoginModel::where('admin_email', $request->username)->first();
        if (empty($user)) {
            return redirect()->back()->with('error', 'We have not found your account');
        }
        $token['token'] = Hash::make($user->admin_email . time());
        $user->pssword_reset_token = $token['token'];
        $user->save();
        $data['url'] = URL::temporarySignedRoute('admin_password_reset_now', now()->addMinute(120), http_build_query($token));
        $data['name'] = $user->admin_name;
        Mail::to($user->admin_email)->send(new PasswordReset($data));
        return redirect()->back()->with('success', 'Please Check Your Email');

    }

    function passwordResetNow(Request $request){

        if(!$request->hasValidSignature()){
            abort(401);
        }
        return view('adminlogin.passwordreset');
    }

    function confirmPasswordReset(Request $request){
        $request->validate([
            'password'=>'required|same:confirm_password|min:8|string',
            'reset_token'=>'required'
        ]);
        $user=AdminLoginModel::Where('pssword_reset_token',$request->reset_token)->first();
        $user->password=Hash::make($request->password);
        $user->pssword_reset_token=null;
        if($user->save()){
            return to_route('admin_login')->with('success','Password Reset Successfully');
        }else{
            return redirect()->back()->with('failed','Found some errors try again');
        }

    }

    function logout()
    {
        Auth::guard('admin')->logout();
        return to_route('admin_login');
    }
}
