<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyGroupModel;
use Illuminate\Http\Request;
use App\Models\Company\CompanyModel;
use Illuminate\Support\Facades\Storage;

class Company extends Controller
{

    function index()
    {
        $company = CompanyModel::where('company_deleted_by',null)->get();
        return view('company.index', compact('company'));
    }

    function create()
    {
        return view('company.create');
    }

    function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:200|string',
            'url' => 'required|max:200|url',
            'identifier' => 'required|max:200|string',
            'secret' => 'required|max:200|string',
            'time_zone'=>'required|max:100|string',
            'signature'=>'required|string',
            'logo' => 'required|mimes:jpeg,png|max:2000'
        ]);
        $company = new CompanyModel();
        $company->company_name = $request->name;
        $company->company_url = $request->url;
        $company->company_identifier = $request->identifier;
        $company->company_secret = $request->secret;
        $company->company_admin_user=$request->support_user;
        $company->company_time_zone=$request->time_zone;
        $company->company_signature=$request->signature;
        $company->company_created_date=date('Y-m-d');
        $company->company_created_by=Auth()->guard('admin')->user()->admin_id;
        $company->company_logo = Storage::disk('public_root')->put('company/', $request->logo);

        if ($company->save()) {
            return redirect()->back()->with('success', 'Successfully Save');
        } else {
            return redirect()->back()->with('error', 'Please Try Again Has Some error');
        }
    }

    function edit($id = '')
    {
        $company = CompanyModel::find($id);
        return view('company.edit', compact('company', 'id'));
    }

    function update($id = '', Request $request)
    {
        $request->validate([
            'name' => 'required|max:200|string',
            'url' => 'required|max:200|url',
            'identifier' => 'required|max:200|string',
            'secret' => 'required|max:200|string',
            'support_user'=>'required|max:200|string',
            'time_zone'=>'required|max:100|string',
            'signature'=>'required|string',
            'logo' => 'nullable|mimes:jpeg,png|max:2000'
        ]);
        $company = CompanyModel::find($id);
        $company->company_name = $request->name;
        $company->company_url = $request->url;
        $company->company_identifier = $request->identifier;
        $company->company_secret = $request->secret;
        $company->company_admin_user=$request->support_user;
        $company->company_time_zone=$request->time_zone;
        $company->company_signature=$request->signature;
        $company->company_updated_date=date('Y-m-d');
        $company->company_updated_by=Auth()->guard('admin')->user()->admin_id;
        if ($request->hasFile($request->logo)) {
            $company->company_logo = Storage::disk('public_root')->put('company/', $request->logo);
        }


        if ($company->save()) {
            return to_route('company_list')->with('success', 'Successfully Save');
        } else {
            return to_route('company_list')->with('error', 'Please Try Again Has Some error');
        }
    }

    function destroy($id = '')
    {
        $companyGroup = CompanyGroupModel::CompanyGroupCheck($id);
        if (empty($companyGroup)) {
            $company = CompanyModel::find($id);
            $company->company_deleted_date=date('Y-m-d');
            $company->company_deleted_by=Auth()->guard('admin')->user()->admin_id;
            if ($company->save()) {
                session()->flash('success', 'Successfully Deleted');
                return response()->json(['success' => true]);
            } {
                session()->flash('error', 'Please Try Again Has Some error');
                return response()->json(['error' => true]);
            }
        }
        session()->flash('error', 'Please Remove From Gorup First');
        return response()->json(['error' => true]);
    }
}
