<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Company\CompanyModel;
use App\Models\Company\CompanyGroupModel;

class CompanyGroup extends Controller
{

    function index()
    {
        $groups = CompanyGroupModel::where('cgroup_deleted_by', null)->get();
        return view('company.group.index', compact('groups'));
    }

    function create()
    {
        $company = CompanyModel::where('company_deleted_by', null)->get();
        return view('company.group.create', compact('company'));
    }

    function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:200|string',
            'company' => 'required|min:1|array'

        ]);
        $result = CompanyGroupModel::store($request);

        if ($result == true) {
            return redirect()->back()->with('success', 'Successfully Save');
        } else {
            return redirect()->back()->with('error', 'Successfully Save');
        }
    }

    function edit($id = '')
    {
        $company = CompanyModel::where('company_deleted_by', null)->get();
        $group = CompanyGroupModel::find($id);
        $groupDetails = CompanyGroupModel::findGroupDetails($id);
        return view('company.group.edit', compact('company', 'id', 'group', 'groupDetails'));
    }

    function update($id = '', Request $request)
    {
        $request->validate([
            'name' => 'required|max:200|string',
            'company' => 'required|min:1|array'

        ]);
        $result = CompanyGroupModel::updateGroup($request,$id);

        if ($result == true) {
            return to_route('cgroup_list')->with('success', 'Successfully Save');
        } else {
            return to_route('cgroup_list')->with('error', 'Successfully Save');
        }
    }

    function destroy($id = '')
    {
        session()->flash('error', 'Please wait this function will available very soon');
        return response()->json(['error' => true]);
    }
}
