<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\RoleModel;
use Illuminate\Support\Facades\DB;

class Role extends Controller
{

    // function __construct()
    // {
    //     $this->middleware('checkPermission:role.view,',['only'=>['roleList']]);
    //     $this->middleware('checkPermission:role.create,',['only'=>['roleCreate','roleStore]]);
    //     $this->middleware('checkPermission:role.edit,',['only'=>['roleEdit','roleUpdate']]);
    //     //$this->middleware('checkPermission:role.delete,',['only'=>['roleDelete']]);

    //     $this->middleware('checkPermission:menu.view,',['only'=>['menu_list']]);
    //     $this->middleware('checkPermission:menu.create,',['only'=>['menu_create','menu_store']]);
    //     $this->middleware('checkPermission:menu.edit,',['only'=>['menu_update','menu_update_store']]);
    //    // $this->middleware('checkPermission:menu.delete,',['only'=>['deleteMenu']]);
    // }

    /**========== Role Permission New Technic  =================== */
    function roleList()
    {
        $role = RoleModel::role_list();
        return view('role.role_list', compact('role'));
    }

    function roleCreate()
    {
        $module = RoleModel::moduleList();
        $permissions = RoleModel::role_permission();
        $menu = RoleModel::menulist();
        return view('role.add_role', compact('module', 'permissions', 'menu'));
    }

    function roleStore(Request $request)
    {

        DB::beginTransaction();

        try {

            $module = RoleModel::moduleList();
            $allMenu = RoleModel::menulist();
            $permissionArray = '';
            $menuArray = '';
            $role_id = DB::table('roles')->insertGetId([
                'role_name' => $request->rolename
            ]);

            foreach ($module as $mod) {
                if (isset($_POST['modulePermission' . $mod->rmodel_id])) {
                    $permissionArray = $_POST['modulePermission' . $mod->rmodel_id];
                    if (is_array($permissionArray)) {
                        for ($i = 0; $i < count($permissionArray); $i++) {
                            DB::table('role_permission_group')->insert([
                                'permission_id' => $permissionArray[$i],
                                'role_id' => $role_id,
                            ]);
                        }
                    }
                }

                if (isset($_POST['moduleMenu' . $mod->rmodel_id])) {
                    $menuArray = $_POST['moduleMenu' . $mod->rmodel_id];
                    if (is_array($menuArray) && is_array($permissionArray)) {
                        for ($i = 0; $i < count($menuArray); $i++) {
                            $pMenu = $allMenu->where('rsmenu_id', $menuArray[$i])->first();
                            if ($pMenu->rsmenu_parentid == 0) {
                                DB::table('role_menu_details')->insert([
                                    'menu_id' => $menuArray[$i],
                                    'role_id' => $role_id,
                                    'model_id' => $mod->rmodel_id
                                ]);
                            } else {
                                $checkParent = DB::table('role_menu_details')->where([
                                    'role_id' => $role_id,
                                    'model_id' => $mod->rmodel_id
                                ])->first();

                                if (empty($checkParent)) {
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $pMenu->rsmenu_parentid,
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $menuArray[$i],
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                } else {
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $menuArray[$i],
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                }
                            }
                        }
                    }
                }
            }
            //end main foreach
            DB::commit();
            return back()->with('msg', 'Successfully Role Added');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('msg', 'Role Not Added');
        }
    }


    function roleEdit($id = '')
    {
        $roleDetails = DB::table('roles')->where('role_id', $id)->first();

        $module = RoleModel::moduleList();
        $permissions = RoleModel::role_permission();
        $menu = RoleModel::menulist();

        $menuInRole = DB::table('role_menu_details')->where('role_id', $id)->get();
        $permissionInRole = DB::table('role_permission_group')->where('role_id', $id)->get();
        return view('role.update_role', compact('module', 'permissions', 'menu', 'menuInRole', 'permissionInRole', 'roleDetails'));
    }

    function roleUpdate($id = '', Request $request)
    {

        DB::beginTransaction();

        try {

            $module = RoleModel::moduleList();
            $allMenu = RoleModel::menulist();
            $permissionArray = '';
            $menuArray = '';

            DB::table('roles')->where('role_id', $id)->update(['role_name' => $request->rolename]);
            $role_id = $id;

            DB::table('role_permission_group')->where('role_id', $role_id)->delete();
            DB::table('role_menu_details')->where('role_id', $role_id)->delete();

            foreach ($module as $mod) {
                if (isset($_POST['modulePermission' . $mod->rmodel_id])) {
                    $permissionArray = $_POST['modulePermission' . $mod->rmodel_id];
                    if (is_array($permissionArray)) {
                        for ($i = 0; $i < count($permissionArray); $i++) {
                            DB::table('role_permission_group')->insert([
                                'permission_id' => $permissionArray[$i],
                                'role_id' => $role_id,
                            ]);
                        }
                    }
                }

                if (isset($_POST['moduleMenu' . $mod->rmodel_id])) {
                    $menuArray = $_POST['moduleMenu' . $mod->rmodel_id];
                    if (is_array($menuArray) && is_array($permissionArray)) {
                        for ($i = 0; $i < count($menuArray); $i++) {
                            $pMenu = $allMenu->where('rsmenu_id', $menuArray[$i])->first();
                            if ($pMenu->rsmenu_parentid == 0) {
                                DB::table('role_menu_details')->insert([
                                    'menu_id' => $menuArray[$i],
                                    'role_id' => $role_id,
                                    'model_id' => $mod->rmodel_id
                                ]);
                            } else {
                                $checkParent = DB::table('role_menu_details')->where([
                                    'role_id' => $role_id,
                                    'model_id' => $mod->rmodel_id
                                ])->first();

                                if (empty($checkParent)) {
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $pMenu->rsmenu_parentid,
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $menuArray[$i],
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                } else {
                                    DB::table('role_menu_details')->insert([
                                        'menu_id' => $menuArray[$i],
                                        'role_id' => $role_id,
                                        'model_id' => $mod->rmodel_id
                                    ]);
                                }
                            }
                        }
                    }
                }
            }
            //end main foreach
            DB::commit();
            return back()->with('msg', 'Successfully Role Updated');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('msg', 'Role Not Updated');
        }
    }

    function roleDelete($id = '')
    {
        DB::beginTransaction();
        try {
            $checkFirst = DB::table('users')->where('user_role', $id)->get();
            if (!$checkFirst->isEmpty($checkFirst)) {
                return redirect()->route('role_list')->with('msg', 'Remove role form user first');
            }
            DB::table('roles')->where('role_id', $id)->delete();
            DB::table('role_permission_group')->where('role_id', $id)->delete();
            DB::commit();
            return redirect()->route('role_list')->with('msg', 'Successfully Deleted');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->route('role_list')->with('msg', 'Please try Again');
        }
    }

    /**============ Role Permission New Technic End ======================= */

    function menuList()
    {
        $menu = RoleModel::menulist();
        return view('role.list_menu', compact('menu'));
    }

    function menuCreate()
    {
        $parent_menu = RoleModel::parent_menu();
        $module = RoleModel::moduleList();
        return view('role.add_menu', compact('parent_menu', 'module'));
    }

    function menuStore(Request $request)
    {
        $request->validate([
            'menu_name' => 'required|max:100',
            'menu_slug' => 'required|max:100',
            'menu_route' => 'required|max:100',
            'menu_icon' => 'nullable|max:100',
            'parent_menu' => 'nullable|numeric',
            'menu_order' => 'required|numeric',
            'module_name' => 'required|numeric',
        ]);

        $result = RoleModel::menuStore($request);
        if ($result == true) {
            return back()->with('msg', 'Successfully Saved');
        } else {
            return back()->with('msg', 'Not Saved');
        }
    }

    function menuEdit($id = "")
    {
        $parent_menu = RoleModel::parent_menu();
        $menu = RoleModel::single_menu($id);
        $module = RoleModel::moduleList();
        return view('role.update_menu', compact('menu', 'parent_menu', 'module', 'id'));
    }

    function menuUpdate($id = '', Request $request)
    {
        $request->validate([
            'menu_name' => 'required|max:100',
            'menu_slug' => 'required|max:100',
            'menu_route' => 'required|max:100',
            'menu_icon' => 'nullable|max:100',
            'parent_menu' => 'required|numeric',
            'menu_order' => 'required|numeric'
        ]);

        $result = RoleModel::menu_update_store($id, $request);
        if ($result == true) {
            return redirect()->route('menu_list')->with('msg', 'Successfully Saved');
        } else {
            return redirect()->route('menu_list')->with('msg', 'Not Saved');
        }
    }

    function deleteMenu($id = '')
    {
        DB::beginTransaction();
        try {
            $checkFirst = DB::table('role_system_menu')->where('rsmenu_parentid', $id)->get();
            if (!$checkFirst->isEmpty($checkFirst)) {
                return redirect()->route('menu_list')->with('msg', 'Remove or move submenu first');
            }
            DB::table('role_menu_details')->where('menu_id', $id)->delete();
            DB::table('role_system_menu')->where('rsmenu_id', $id)->delete();
            DB::commit();
            return redirect()->route('menu_list')->with('msg', 'Successfully Deleted');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->route('menu_list')->with('msg', 'Please try Again');
        }
    }

    /**role Permission making */
}
