<?php

namespace App\Http\Controllers;

use App\Mail\PasswordReset;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use App\Helpers\ClientInfo;
use App\Models\LoginHistoryModel;

class UserLogin extends Controller
{
    function index()
    {
        //return Auth::getRecallerName();//get cookie for remember
        if (Auth::check() || Auth::viaRemember()) {
            return redirect()->route('agentdashboard');
        } else {
            return view('userlogin.login');
        }
    }

    function checkLogin(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required'
        ]);
        $user = User::where('user_name', $request->username)->where('user_status','active')->where('user_deleted_date',null)->first();

        if (!empty($user) && Hash::check($request->password, $user->password)) {
            Auth::login($user, $request->remember_me);
           // $this->storeLoginHostory($user->user_id);
            return redirect()->route('agentdashboard');
        } else {
            return redirect()->back()->with('failed', 'User name or password wrong');
        }
    }

    function storeLoginHostory($admin_id=''){
        $mac=ClientInfo::getMac();
        $ip=ClientInfo::getClientIp();
        $ipDetails=ClientInfo::getIpDetails($ip);
        $browser=ClientInfo::getBrowser();

        $data=new LoginHistoryModel();
        $data->mac=$mac['mac'];
        $data->ip_address=$ip;
        $data->country=$ipDetails['country_name'];
        $data->browser=$browser;
        $data->user_id=$admin_id;
        $data->login_datetime=date('Y-m-d H:i:s');
        $data->save();
    }

    function forgetPassword()
    {
        return view('userlogin.forgetpassword');
    }

    function sendResetEmail(Request $request)
    {
       $user = User::where('user_name', $request->username)->where('user_status','active')->where('user_deleted_date',null)->first();
        if (empty($user)) {
            return redirect()->back()->with('error', 'We have not found your account');
        }
        $token['token'] = Hash::make($user->user_email . time());
        $user->pssword_reset_token = $token['token'];
        $user->save();
        $data['url'] = URL::temporarySignedRoute('password_reset_now', now()->addMinute(120), http_build_query($token));
        $data['name'] = $user->user_name;
        Mail::to($user->user_email)->send(new PasswordReset($data));
        return redirect()->back()->with('success', 'Please Check Your Email');

    }

    function passwordResetNow(Request $request){

        if(!$request->hasValidSignature()){
            abort(401);
        }
        return view('userlogin.passwordreset');
    }

    function confirmPasswordReset(Request $request){
        $request->validate([
            'password'=>'required|same:confirm_password|min:8|string',
            'reset_token'=>'required'
        ]);
        $user=User::Where('pssword_reset_token',$request->reset_token)->first();
        $user->password=Hash::make($request->password);
        $user->pssword_reset_token=null;
        if($user->save()){
            return to_route('login')->with('success','Password Reset Successfully');
        }else{
            return redirect()->back()->with('failed','Found some errors try again');
        }
    }

    function logout()
    {
        Auth::guard('web')->logout();
        return to_route('login');
    }

}
