<?php

namespace App\Http\Controllers;

use App\Models\Company\CompanyGroupModel;
use App\Models\Company\CompanyModel;
use App\Models\RoleModel;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class Users extends Controller
{
    function __construct()
    {
        //     $this->middleware('checkPermission:user.view,',['only'=>['index']]);
        //     $this->middleware('checkPermission:user.create,',['only'=>['create','store]]);
        //     $this->middleware('checkPermission:user.edit,',['only'=>['edit','update']]);
        //     $this->middleware('checkPermission:user.delete,',['only'=>['delete']]);
    }

    function index()
    {
        $userList = User::userList();
        return view('users.index', compact('userList'));
    }

    function create()
    {
        $role = RoleModel::role_list();
        $cgroup=CompanyGroupModel::all();
        $company=CompanyModel::all();
        return view('users.create', compact('role','cgroup','company'));
    }

    function store(Request $request)
    {
        /**  'regex:/^.*(?=.{3,})(?=.*[a-zA-Z])(?=.*[0-9])(?=.*[\d\x])(?=.*[!$#%]).*$/'    for password */
        $request->validate([
            'name' => 'required|string|max:200',
            'username' => 'required|string|max:100|unique:users,user_name',
            'email' => 'required|email|unique:users,user_email',
            'phone' => 'nullable|string|max:15',
            'password' => 'required|string|max:32|min:8',
            'role' => 'required|numeric',
            'company'=>'required|array',
            'status' => 'required|in:active,inactive',
            'address' => 'nullable|max:255'
        ]);

        $result = User::store($request);
        if ($result == true) {
            return back()->with('success', 'Successfully Saved');
        } else {
            return back()->with('error', 'Not Saved');
        }
    }

    function edit($id = '')
    {
        $user = User::singleUser($id);
        $role = RoleModel::role_list();
        $company=CompanyModel::all();
        return view('users.edit', compact('user', 'role', 'company','id'));
    }

    function update($id = '', Request $request)
    {
        /**  'regex:/^.*(?=.{3,})(?=.*[a-zA-Z])(?=.*[0-9])(?=.*[\d\x])(?=.*[!$#%]).*$/'    for password */
        $request->validate([
            'name' => 'required|string|max:200',
            'username' => 'required|string|max:100|unique:users,user_name,' . $id . ',user_id',
            'email' => 'required|email|unique:users,user_email,' . $id . ',user_id',
            'phone' => 'nullable|string|max:15',
            'password' => 'nullable|string|max:32|min:8',
            'role' => 'required|numeric',
            'company'=>'required|array',
            'status' => 'required|in:active,inactive',
            'address' => 'nullable|max:255'
        ]);

        $result = User::updateStore($id, $request);
        if ($result == true) {
            return to_route('user_list')->with('success', 'Successfully Saved');
        } else {
            return to_route('user_list')->with('error', 'Not Saved');
        }
    }

    function delete($id=''){
        $result = User::destroy($id);
        if ($result == true) {
            return to_route('user_list')->with('msg', 'Successfully Saved');
        } else {
            return to_route('user_list')->with('msg', 'Not Saved');
        }
    }


    /**===================== update signature by self user ==================== */
    function signature(){
        return view('users.signature');
    }

    function signatureStore(Request $request){
              //return json_encode($request->message);
        $findReplace=array('<strong>','</strong>','<em>','</em>','<p>','</p>','<script>','</script>');
        $replace=array('**','**','*','*','','',' ','');
        $finalSignature=strip_tags(strip_tags(str_replace('&nbsp;', ' ', $request->message))); //str_replace($findReplace,$replace,$request->message);

       // $finalSignature=strip_tags(strip_tags($finalSignature));
        $user=User::find(Auth::guard('web')->user()->user_id);
        $user->user_signature=$finalSignature;
        if ($user->save()) {
            return back()->with('success', 'Successfully Saved');
        } else {
            return back()->with('error', 'Not Saved');
        }

    }
}
