<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\RoleModel;

class CheckPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next,$permission,$guard=null)
    {

        $menuInfo = RoleModel::checkPermission($permission);

        if (!empty($menuInfo)) {
            return $next($request);
        } else {
            //return response(['error' => ['title' => 'Access Denied', 'message' => 'You are not permitted to see this page']]);
            if ($request->ajax()) {
                return response()->json(['acc_error' => '<p class="text-center"><span style="font-size:36">Access Denied!</span> <br/> You dont have permission to do this job</p>']);
            } else {
                return response()->view('errors.access_denied');
                exit;
            }
        }
    }
}
