<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Helpers\ArrayHelper;

class CompanyGroupModel extends Model
{
    use HasFactory;
    protected $table = 'company_group';
    protected $primaryKey = 'cgroup_id';
    public $timestamps = false;

    public static function CompanyGroupCheck($id)
    {
        return DB::table('company_group_details')->where('company_id', $id)->first();
    }

    public static function store($request)
    {
        $arrayHelper = new ArrayHelper();
        DB::beginTransaction();
        try {
            $gorupId = DB::table('company_group')->insertGetId([
                'cgroup_name' => $request->name,
                'cgroup_created_date' => date('Y-m-d'),
                'cgroup_created_by' => Auth()->guard('admin')->user()->admin_id
            ]);

            $details = $arrayHelper->removeNullValues($request->company);
            $details = $arrayHelper->arrayValues($details);
            for ($i = 0; $i < count($details); $i++) {
                DB::table('company_group_details')->insert([
                    'company_ids' => $details[$i],
                    'company_group_id' => $gorupId
                ]);
            }
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }

    public static function updateGroup($request,$id)
    {
        $arrayHelper = new ArrayHelper();
        DB::beginTransaction();
        try {
            DB::table('company_group_details')->where('company_group_id',$id)->delete();
            DB::table('company_group')->where('cgroup_id',$id)->update([
                'cgroup_name' => $request->name,
                'cgroup_updated_date' => date('Y-m-d'),
                'cgroup_updated_by' => Auth()->guard('admin')->user()->admin_id
            ]);

            $details = $arrayHelper->removeNullValues($request->company);
            $details = $arrayHelper->arrayValues($details);
            for ($i = 0; $i < count($details); $i++) {
                DB::table('company_group_details')->insert([
                    'company_ids' => $details[$i],
                    'company_group_id' => $id
                ]);
            }
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }

    public static function findGroupDetails($id){
        return DB::table('company_group')->join('company_group_details','company_group.cgroup_id','=','company_group_details.company_group_id')
        ->join('company_information','company_group_details.company_ids','=','company_information.company_id')->where('company_group_id',$id)->get();
    }


}
