<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class RoleModel extends Model
{
    use HasFactory;

    /**===================== Role Process Begain New ===================== */
    public static function role_list()
    {
        return DB::table('roles')->get();
    }

    public static function moduleList()
    {
        return DB::table('role_model')->get();
    }

    public static function menulist()
    {
        return DB::table("role_system_menu")->orderBy('rsmenu_order', 'asc')->get();
    }


    public static function parent_menu()
    {
        return DB::table("role_system_menu")->where('rsmenu_parentid', 0)->orderBy('rsmenu_id', 'asc')->get();
    }

    public static function menu_in_role()
    {
        $data = DB::table('role_menu_details')->join('roles', 'role_menu_details.role_id', '=', 'roles.role_id')
            ->join('role_system_menu', 'role_menu_details.menu_id', '=', 'role_system_menu.rsmenu_id')
            ->where(['role_menu_details.role_id' => Auth()->user()->user_role])
            ->groupBy('role_menu_details.menu_id')->orderBy('role_system_menu.rsmenu_order', 'asc')->get();
        return $data;
    }

    public static function checkPermission($slugs)
    {
        return DB::table('role_permissions')->join('role_has_permissions', 'role_permissions.rp_id', '=', 'role_has_permissions.permission_id')->where('rp_name', $slugs)->where('role_id', Auth()->user()->user_role)->first();
    }
    public static function single_menu($id)
    {
        return DB::table('role_system_menu')->where('rsmenu_id', $id)->first();
    }


    public static function role_permission()
    {
        return DB::table('role_permissions')->get();
    }

    public static function menuStore($request)
    {
        DB::beginTransaction();
        try {
            DB::table('role_system_menu')->insert([
                'rsmenu_name' => $request->menu_name,
                'rsmenu_slug' => $request->menu_slug,
                'rsmenu_route' => $request->menu_route,
                'rsmenu_parentid' => $request->parent_menu,
                'rsmenu_icon' => $request->menu_icon,
                'rsmenu_order' => $request->menu_order,
                'model_id' => $request->module_name,
            ]);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }


    public static function menu_update_store($id,$request)
    {
        DB::beginTransaction();
        try {
            DB::table('role_system_menu')->where('rsmenu_id', $id)->update([
                'rsmenu_name' => $request->menu_name,
                'rsmenu_slug' => $request->menu_slug,
                'rsmenu_route' => $request->menu_route,
                'rsmenu_parentid' => $request->parent_menu,
                'rsmenu_icon' => $request->menu_icon,
                'rsmenu_order' => $request->menu_order,
                'model_id' => $request->module_name,
            ]);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }
    public static function sub_menu_list($id)
    {
        return DB::table("role_system_menu")->where('rsmenu_parentid', $id)->orderBy('rsmenu_id', 'asc')->get();
    }

    public static function single_role($id)
    {
        return DB::table('system_role')->where('role_id', $id)->first();
    }

    public static function action()
    {
        return DB::table('system_action')->get();
    }

    /**===================== End Role Process Begain New ===================== */


}
