<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'users';
    protected $primaryKey = 'user_id';
    public $timestamps = false;

    public static function userList()
    {
        return DB::table('users')->join('user_details', 'users.user_id', '=', 'user_details.user_ids')->where('user_deleted_by', null)->get();
    }

    public static function singleUser($id)
    {
        return DB::table('users')->join('user_details', 'users.user_id', '=', 'user_details.user_ids')->where('user_id', $id)->first();
    }
    public static function store($request)
    {
        DB::beginTransaction();
        try {
            $userId = DB::table('users')->insertGetId([
                'user_name' => $request->username,
                'user_email' => $request->email,
                'password' => Hash::make($request->password),
                'user_role' => $request->role,
                'user_status' => $request->status,
                'user_company'=>(is_array($_POST['company']))?json_encode($_POST['company']):'',
                'user_created_date' => date('Y-m-d'),
                'user_created_by' => Auth()->guard('admin')->user()->admin_id
            ]);

            DB::table('user_details')->insert([
                'user_ids' => $userId,
                'user_fullname' => $request->name,
                'user_phone' => $request->phone,
                'user_address' => $request->address
            ]);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }

    public static function updateStore($id, $request)
    {
        DB::beginTransaction();
        try {
            DB::table('users')->where('user_id', $id)->update([
                'user_name' => $request->username,
                'user_email' => $request->email,
                'user_role' => $request->role,
                'user_status' => $request->status,
                'user_company'=>(is_array($_POST['company']))?json_encode($_POST['company']):'',
                'user_updated_date' => date('Y-m-d'),
                'user_updated_by' => Auth()->guard('admin')->user()->admin_id
            ]);
            if ($request->password != "") {
                DB::table('users')->where('user_id', $id)->update([
                    'password' => Hash::make($request->password),
                ]);
            }
            DB::table('user_details')->where('user_ids', $id)->update([
                'user_fullname' => $request->name,
                'user_phone' => $request->phone,
                'user_address' => $request->address
            ]);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }

    public static function destroy($id)
    {
        DB::beginTransaction();
        try {
            DB::table('users')->where('user_id', $id)->update([
                'user_status' => 'inactive',
                'user_deleted_date' => date('Y-m-d'),
                'user_deleted_by' => Auth()->guard('admin')->user()->admin_id
            ]);
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            return false;
        }
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_name',
        'user_email',
        'password',
        'user_status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
