<?php

namespace App\Traits;

trait ApiResponseTrait
{
    /**
     * Respond with a success message.
     *
     * @param string $message
     * @param array $data
     * @param int $statusCode
     * @return \Illuminate\Http\JsonResponse
     */
    protected function successResponse($message, $data = [], $statusCode = 200)
    {
        return response()->json([
            'statusCode'=>$statusCode,
            'status' => 'success',
            'message' => $message,
            'data' => $data,
        ], $statusCode);
    }

    /**
     * Respond with an error message.
     *
     * @param string $message
     * @param int $statusCode
     * @return \Illuminate\Http\JsonResponse
     */
    protected function errorResponse($message, $statusCode)
    {
        return response()->json([
            'statusCode'=>$statusCode,
            'status' => 'error',
            'message' => $message,
        ], $statusCode);
    }

    protected function firstDataCheck($data){
        return (empty($data))? 'No data found':'';
    }

    protected function getDataCheck($data){
        return ($data->isEmpty())?'No data found':'';
    }
}
