function genPassword() {
    var chars = "0123456789abcdefghijklmnopqrstuvwxyz!@#$%^&*()ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var passwordLength = 15;
    var password = "";
    for (var i = 0; i <= passwordLength; i++) {
        var randomNumber = Math.floor(Math.random() * chars.length);
        password += chars.substring(randomNumber, randomNumber + 1);
    }
    document.getElementById("password").value = password;
    strongPassword(password);
}

function strongPassword(password) {

    if (password.length === 0) {
        document.getElementById("passwordStrength").innerHTML = "";
        return;
    }
    // Create an array and push all possible values that you want in password
    var matchedCase = new Array();
    matchedCase.push("[$@$!%*#?&]"); // Special Charector
    matchedCase.push("[A-Z]"); // Uppercase Alpabates
    matchedCase.push("[0-9]"); // Numbers
    matchedCase.push("[a-z]"); // Lowercase Alphabates

    // Check the conditions
    var ctr = 0;
    for (var i = 0; i < matchedCase.length; i++) {
        if (new RegExp(matchedCase[i]).test(password)) {
            ctr++;
        }
    }
    // Display it
    var color = "";
    var strength = "";
    switch (ctr) {
        case 0:
        case 1:
        case 2:
            strength = "Very Weak Password";
            color = "red";
            break;
        case 3:
            strength = "Medium Password";
            color = "orange";
            break;
        case 4:
            strength = "Strong Password";
            color = "green";
            break;
    }
    document.getElementById("passwordStrength").innerHTML = strength;
    document.getElementById("passwordStrength").style.color = color;
}

function copyClipBoard(boardId) {
    var copyText = document.getElementById(boardId);
    copyText.select();
    copyText.setSelectionRange(0, 99999); // For mobile devices
    window.navigator.clipboard.writeText(copyText.value);
    alert("Copied the text: " + copyText.value);
}
