
function deleteData(url) {

    Swal.fire({
        title: 'Delete',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirm',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {

            fetch(url, {
                method: 'DELETE'
                , headers: {
                    'Content-type': 'application/json'
                    , 'X-CSRF-TOKEN': $('meta[name="token"]').attr('content')
                }
            })
                .then((response) => response.json())
                .then((data) => {
                    window.location.reload();
                })
        }
    });

}


function updateData(url) {

    fetch(url, {
        method: 'PUT'
        , headers: {
            'Content-type': 'application/json'
            , 'X-CSRF-TOKEN': $('meta[name="token"]').attr('content')
        }
    }).then((response) => response.json())
        .then((data) => {
            window.location.reload();
        })

}

