<!doctype html>
<html>

<head>
    <meta charset='utf-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1'>
    <title>Forget Password</title>
    @include('adminlogin.partial.header')
</head>

<body className='snippet-body'>
    <div class="wrapper">
        <div class="logo">
            <img src="{{ asset('logo/logo.png') }}" class="img-fluid" alt="">
        </div>
        <div class="text-center mt-4 name">
            Central Support
        </div>
        <form class="p-3 mt-3" action="{{route('admin_send_reset_email')}}" method="post">
            @csrf
            <div class="form-field d-flex align-items-center">
                <span class="far fa-user"></span>
                <input type="text" name="username" id="username" placeholder="Enter The Username" autocomplete="off" required>
            </div>
            @if(session()->has('error'))
                    <p style="color:red;">{{session()->get('error')}}</p>
                @endif
                @if(session()->has('success'))
                    <p style="color:green;">{{session()->get('success')}}</p>
                @endif
            <button type="submit" class="btn mt-3">Send Reset Link</button>
        </form>
        <div class="text-center fs-6">
            <a href="{{route('admin_login')}}">Login</a>
        </div>
    </div>

    @include('adminlogin.partial.footer')

</body>

</html>
