<!doctype html>
<html>

<head>
    <meta charset='utf-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1'>
    <title>Password Reset {{config('app.name')}}</title>
    @include('adminlogin.partial.header')
</head>

<body className='snippet-body'>
    <div class="wrapper">
        <div class="logo">
            <img src="{{ asset('logo/logo.png') }}" alt="" class="img-fluid">
        </div>
        <div class="text-center mt-4 name">
            {{config('app.name')}}
        </div>
        <form class="p-3 mt-3" method="post" action="{{route('admin_confirm_password_reset')}}">
            @csrf
            <input type="hidden" name="reset_token" value="{{$_GET['token']}}">
            <div class="form-field d-flex align-items-center">
                <span class="far fa-user"></span>
                <input type="password" name="password" id="password" placeholder="Password">
            </div>
            <div class="form-field d-flex align-items-center">
                <span class="fas fa-key"></span>
                <input type="password" name="confirm_password" id="confirm_password" placeholder="Confirm Password">
            </div>
            @if(session()->has('failed'))
                <p style="color:red;">{{session()->get('failed')}}</p>
            @endif
            <button class="btn mt-3">Reset</button>
        </form>
        <div class="text-center fs-6">
            <a href="#">Login?</a>
        </div>
    </div>

    @include('adminlogin.partial.footer')

</body>

</html>
