@extends('tpl.user.layout')
@section('title', 'Product Details')
@push('css')
    <link rel="stylesheet" href="{{ asset('admin/vendor/DataTables/datatables.min.css') }}">
@endpush

@section('content')

    @php
        $productDetails = json_decode($productDetails['response'], true);
        $finalProduct = $productDetails['products']['product'];
        // echo '<pre>';
        // print_r($productDetails);
    @endphp
    <div class="row">
        <div class="col-sm-12 displaynone" id="loading">
            <div class="d-flex justify-content-center">
                <div class="spinner-border" role="status"> <span class="visually-hidden">Loading...</span></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Order #</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['orderid'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">Registration Date</label>
            <input type="text" class="form-control" value="{{ date('d/m/Y', strtotime($finalProduct[0]['regdate'])) }}"
                readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Product/Service</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['name'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">Quantity</label>
            <input type="text" class="form-control" value="1" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Server</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['servername'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">First Payment Amount</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['firstpaymentamount'] }}" readonly>
            <label class="form-label">Recurring Amount</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['recurringamount'] }}" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Domain</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['domain'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">Next Due Date</label>
            <input type="text" class="form-control"
                value="{{ date('d/m/Y', strtotime($finalProduct[0]['nextduedate'])) }}" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Dedicated IP</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['dedicatedip'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">Termination Date</label>
            <input type="text" class="form-control" value="" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Username</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['username'] }}" readonly>
        </div>
        <div class="col-sm-6">
            <label class="form-label">Billing Cycle</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['billingcycle'] }}" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Password</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['password'] }}">
        </div>
        <div class="col-sm-6">
            <label class="form-label">Payment Method</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['paymentmethodname'] }}" readonly>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <label class="form-label">Status</label>
            <input type="text" class="form-control" value="{{ $finalProduct[0]['status'] }}" readonly>
        </div>

    </div>

    <div class="row mt-2">
        <div class="col-sm-12" id="buttonGroup">
            <div class="btn-group">
                <a href="{{ url()->signedRoute('product_create', ['serviceid' => $finalProduct[0]['id'], 'com' => $company]) }}" class="btn btn-outline-info" onclick="return confirm('Are you sure want to create')">Create</a>
                <button class="btn btn-outline-warning" data-bs-toggle="modal"
                    data-bs-target="#suspension">Suspend</button>
                <a href="{{ url()->signedRoute('product_unsuspend', ['serviceid' => $finalProduct[0]['id'], 'com' => $company]) }}"
                    class="btn btn-outline-success"
                    onclick="return confirm('Are you sure want to suspend it')">Unsuspend</a>
                <a href="{{ url()->signedRoute('product_terminate', ['serviceid' => $finalProduct[0]['id'], 'com' => $company]) }}"
                    class="btn btn-outline-danger"
                    onclick="return confirm('Are you sure want to terminate it')" class="btn btn-outline-danger">Terminate</a>
                <button class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#passwordChange">Change
                    Password</button>
                {{-- <a class="btn btn-outline-primary"
                    href="{{ url()->signedRoute('cpanel_autologin', ['server' => $finalProduct[0]['serverhostname'], 'port' => '2083', 'cpuser' => $finalProduct[0]['username'], 'cppass' => $finalProduct[0]['password']]) }}">Login</a> --}}
            </div>
        </div>
    </div>
@endsection


<div class="modal fade" id="suspension" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Service Suspension</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="text" max="200" id="suspension_reason" class="form-control">
                <input type="text" id="company" value="{{ $company }}" style="display: none;">
                <input type="text" id="serviceid" value="{{ $finalProduct[0]['id'] }}" style="display: none;">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No</button>
                <button type="button" class="btn btn-primary" onclick="suspend()">Yes</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="passwordChange" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Change Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <label for="password" class="form-label">Password <span class="required">*</span></label>

                <div class="input-group">
                    <input type="text" class="form-control" id="password" name="password"
                        placeholder="o&amp;@pPhK*!^nao" onkeypress="strongPassword(this.value)">
                    <div class="btn-group">
                        {{-- <button class="btn btn-secondary" type="button" id="ibutton"
                            onclick="copyClipBoard('password')">copy</button> --}}
                        <button class="btn btn-primary" type="button" onclick="genPassword()"
                            title="password">gen</button>
                    </div>
                </div>
                <span id="passwordStrength" style="color: green;"></span>
                <input type="text" id="company" value="{{ $company }}" style="display: none;">
                <input type="text" id="serviceid" value="{{ $finalProduct[0]['id'] }}" style="display: none;">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No</button>
                <button type="button" class="btn btn-primary" onclick="changePassword()">Yes</button>
            </div>
        </div>
    </div>
</div>
@push('script')
<script src="{{asset('module/common.js')}}"></script>
@endpush
<script>
    function suspend() {

        var myModalEl = document.getElementById('suspension')
        var modal = bootstrap.Modal.getInstance(myModalEl) // Returns a Bootstrap modal instance
        modal.hide();
        document.getElementById("buttonGroup").classList.add("unClickable");
        document.getElementById("loading").classList.remove("displaynone");
        document.getElementById("loading").classList.add("displayshow");

        var suspension_reason = $('#suspension_reason').val();
        var serviceId = $('#serviceid').val();
        let Company = $('#company').val();
        var url =
            "{{ route('product_suspend', ['serviceid' => 'myservice', 'com' => 'company', 'reason' => 'mySuspension']) }}";
        url = url.replace('myservice', serviceId);
        url = url.replace('company', Company);
        url = url.replace('mySuspension', suspension_reason);

        fetch(url)
            .then((response) => response.json())
            .then((data) => {
                location.reload();
            })

    }

    function changePassword() {

        var myModalEl = document.getElementById('passwordChange')
        var modal = bootstrap.Modal.getInstance(myModalEl) // Returns a Bootstrap modal instance
        modal.hide();
        document.getElementById("buttonGroup").classList.add("unClickable");
        document.getElementById("loading").classList.remove("displaynone");
        document.getElementById("loading").classList.add("displayshow");

        var password = $('#password').val();
        var serviceId = $('#serviceid').val();
        let Company = $('#company').val();
        var url =
            "{{ route('product_changepwd', ['serviceid' => 'myservice', 'com' => 'company', 'pass' => 'mypassword']) }}";
        url = url.replace('myservice', serviceId);
        url = url.replace('company', Company);
        url = url.replace('mypassword', password);

        fetch(url)
            .then((response) => response.json())
            .then((data) => {
                location.reload();
            })

    }
</script>


<style>
    .unClickable {
        pointer-events: none;
        opacity: 0.5;
    }

    .displaynone {
        display: none;
    }

    .displayshow {
        display: block;
        background: #ffffff;
        padding: 10px;
    }
</style>
