@extends('tpl.user.layout')
@section('title', 'Company Wise Ticket Status')

@push('css')
    <style>
        :root {
            --main-color: #FF2B51;
        }

        .counter {
            font-family: 'Rubik', sans-serif;
            text-align: center;
            width: 210px;
            margin: 0 auto;
        }

        .counter .counter-icon {
            color: var(--main-color);
            font-size: 30px;
            padding: 0 0 30px;
            overflow: hidden;
            position: relative;
        }

        .counter .counter-icon:after {
            content: '';
            background-color: var(--main-color);
            height: 30px;
            width: 30px;
            transform: translateX(-50%) rotate(45deg);
            position: absolute;
            left: 50%;
            bottom: -15px;
        }

        .counter .counter-content {
            color: #fff;
            /* background-color: var(--main-color); */
            padding: 15px 20px 35px;
            position: relative;
            z-index: 1;
            clip-path: polygon(0 0, 100% 0, 100% 50%, 50% 100%, 0 50%);
        }

        .counter .counter-content:before {
            content: '';
            background-color: #111;
            position: absolute;
            left: 10px;
            right: 10px;
            bottom: 10px;
            top: 0;
            z-index: -1;
            clip-path: inherit;
        }

        .counter h3 {
            font-size: 17px;
            font-weight: 400;
            letter-spacing: 0.5px;
            text-transform: capitalize;
            margin: 0 0 10px;
        }

        .counter .counter-value {
            font-size: 30px;
            line-height: 30px;
            font-weight: 600;
        }

        .counter.purple {
            --main-color: #6c5ce7;
        }

        .counter.orange {
            --main-color: #d35400;
        }

        .counter.blue {
            --main-color: #0097e6;
        }

        @media screen and (max-width:990px) {
            .counter {
                margin-bottom: 40px;
            }
        }
    </style>
@endpush

@section('content')

    <div class="row">
        @for ($i = 0; $i < count($tickets); $i++)

            @php
                $company = $company->where('company_id', $tickets[$i]['company'])->first();
                $chckArray = json_decode($tickets[$i]['response'], true);
            @endphp

            @if (is_array($chckArray) && $tickets[$i]['http_code'])
                <div class="col-sm-12">
                    <img src="{{ asset($company->company_logo) }}" class="img-fluid" style="max-height:80px;" alt="{{ $company->company_name }}">
                    <hr/>
                </div>

                @foreach ($chckArray['status'] as $key => $value)
                    <div class="col-md-3 col-sm-6">
                        <div class="counter">
                            <div class="counter-icon"><i class="fa fa-globe"></i></div>
                            <div class="counter-content" style="background-color:#{{substr(md5(rand()), 0, 6)}}">
                                <h3>{{ $value['title'] }}</h3>
                                <span class="counter-value">{{ $value['count'] }}</span>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif

        @endfor
    </div>
@endsection

@push('script')
    <script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
    {{-- <script>
        $(document).ready(function() {
            $('.counter-value').each(function() {
                $(this).prop('Counter', 0).animate({
                    Counter: $(this).text()
                }, {
                    duration: 3500,
                    easing: 'swing',
                    step: function(now) {
                        $(this).text(Math.ceil(now));
                    }
                });
            });
        });
    </script> --}}
@endpush
