@extends('tpl.user.layout')
@section('title', 'Company Wise Ticket Status')

@section('content')

    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Ticket List</h5>
                    {{-- <pre>
    {{print_r($tickets)}} --}}
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Ticket Number</th>
                                    <th>Department</th>
                                    <th>Status</th>
                                    <th>Priority</th>
                                    <th>Subject</th>
                                    <th>Last Reply</th>
                                    <th>Company</th>
                                    <th>#</th>
                                </tr>
                            </thead>
                            <tbody>
                                @for ($i = 0; $i < count($tickets); $i++)

                                    @php
                                        $company = $company->where('company_id', $tickets[$i]['company'])->first();
                                        $chckArray = json_decode($tickets[$i]['response'], true);
                                    @endphp

                                    @if (is_array($chckArray) && $tickets[$i]['http_code']==200 &&  $chckArray['result']!='error')
                                        @if($chckArray['totalresults']>0)
                                            @foreach ($chckArray['tickets']['ticket'] as $key => $farray)
                                            @if($farray['status']!='Answered')
                                                <tr>
                                                    <td>{{ $farray['tid'] }}</td>
                                                    <td>{{ $farray['deptname'] }}</td>
                                                    <td>{{ $farray['status'] }}</td>
                                                    <td>{{ $farray['priority'] }}</td>
                                                    <td>{{ $farray['subject'] }}</td>
                                                    <td> @php echo timeDiffrent($farray['lastreply'],$company->company_time_zone); @endphp </td>
                                                    <td><img src="{{ asset($company->company_logo) }}" class="img-fluid"
                                                            style="max-height:30px;" alt="{{ $company->company_name }}"></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="{{ url()->signedRoute('ticket_reply', ['tid' => $farray['id'], 'client' => $farray['userid'], 'com' => $tickets[$i]['company']]) }}"
                                                                class="btn btn-success btn-sm"><i class="bi bi-reply"></i></a>
                                                            <a href="{{ url()->signedRoute('closed_ticket_status', ['tid' => $farray['id'],'com' => $tickets[$i]['company']]) }}"
                                                                class="btn btn-danger btn-sm" onclick="return confirm('Are You Sure Closed This Ticket')" title="Closed Ticket"><i class="bi bi-x-circle"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @else
                                    <tr>
                                        <td colspan="6"><center> <b>Error: {{ $chckArray['message'] }} </b></center></td>
                                        <td><img src="{{ asset($company->company_logo) }}" class="img-fluid"
                                            style="max-height:30px;" alt="{{ $company->company_name }}"></td>
                                            <td></td>

                                    </tr>
                                    @endif
                                @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection


@php

    function timeDiffrent($replyTime,$timezone){
        $defaultTimeZone=date_default_timezone_get();
        date_default_timezone_set($timezone);
        $datetime_1 =$replyTime;
        $datetime_2 = date('Y-m-d H:i:s');

        $start_datetime = new DateTime($datetime_1);
        $diff = $start_datetime->diff(new DateTime($datetime_2));
        //$returnAbleData=$defaultTimeZone.' New = '.date_default_timezone_get();//$diff->h.'Hours '.$diff->i.' Minutes Ago';
        $returnAbleData=$diff->d.'D '.$diff->h.'H '.$diff->i.'M';
        date_default_timezone_set($defaultTimeZone);
        return $returnAbleData;
    }

@endphp
