@extends('tpl.user.layout')
@section('title', 'Company Wise Ticket Status')
@push('css')
    <link rel="stylesheet" href="{{ asset('admin/vendor/DataTables/datatables.min.css') }}">
@endpush

@section('content')

    @php
        $reply = json_decode($tickets['response'], true);

        $status = json_decode($status['response'], true);
        $department = json_decode($department['response'], true);
        //$clientProductss = json_decode($clientProducts['response'], true);

        $serviceId= str_replace(array('S','D'),'',$reply['service']);
        $randTablId=rand();
        //echo '<pre>';
        //print_r($reply);
        //print_r($clientProductss);
    @endphp
<input type="hidden" name="tid" id="tid" value="{{$reply['ticketid']}}">
<input type="hidden" name="company" id="company" value="{{$com->company_id}}">
<div class="row bg-white pt-5">
    <div class="col-sm-4">
        <div class="d-flex p-2 bd-highlight">
            <h4><label class="form-label">#{{ $reply['tid'] }}- {{ $reply['subject'] }}</label></h4>
        </div>
    </div>
    <div class="col-sm-2">
        <select name="update_status" id="update_status" class="form-control mt-2" onchange="updateTicket()">

            @foreach ($status['statuses']['status'] as $key => $value)
                <option value="{{ $value['title'] }}" @if ($reply['status']==$value['title'])
                selected
            @endif>{{ $value['title'] }}</option>
            @endforeach
        </select>
        @error('status')
            {{ $message }}
        @enderror
    </div>
</div>
<div class="row">
        <div class="col-sm-12 bg-white rounded-3">

            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="addreply-tab" data-bs-toggle="tab" data-bs-target="#addreply"
                        type="button" role="tab" aria-controls="addreply" aria-selected="true">Add Reply</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="addnote-tab" data-bs-toggle="tab" data-bs-target="#addnote" type="button"
                        role="tab" aria-controls="addnote" aria-selected="false">Add Note <sup class="bg-warning p-1 text-white fw-bolder rounded-2" id="totalnote">0</sup></button>
                </li>
            </ul>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active pt-2" id="addreply" role="tabpanel" aria-labelledby="home-tab">
                    <form
                        action="{{ url()->signedRoute('post_ticket_reply', ['tid' => $reply['ticketid'], 'client' => $reply['userid'], 'com' => $com->company_id]) }}"
                        method="post" enctype="multipart/form-data">

                        @csrf
                        <textarea name="message" id="message" placeholder="write message" required> </textarea>
                        <div class="row">
                            <div class="col-sm-4">
                                <select name="status" id="status" class="form-control mt-2" required>

                                    @foreach ($status['statuses']['status'] as $key => $value)
                                        <option value="{{ $value['title'] }}" @if ($reply['status']==$value['title'])
                                        selected
                                    @endif>{{ $value['title'] }}</option>
                                    @endforeach
                                </select>
                                @error('status')
                                    {{ $message }}
                                @enderror
                            </div>
                            <div class="col-sm-4">
                                <select name="department" id="department" class="form-control mt-2" required>
                                    <option value="">Choose Department</option>
                                    @foreach ($department['departments']['department'] as $key => $value)
                                        <option value="{{ $value['id'] }}" @if ($reply['deptname']==$value['name'])
                                            selected
                                        @endif>{{ $value['name'] }}</option>
                                    @endforeach
                                </select>
                                @error('department')
                                    {{ $message }}
                                @enderror
                            </div>
                            <div class="col-sm-4">
                                <select name="priority" id="priority" class="form-control mt-2" required>
                                    <option value="">Set Priority</option>
                                    <option value="High" @if ($reply['priority'] == 'High') selected @endif>High</option>
                                    <option value="Medium" @if ($reply['priority'] == 'Medium') selected @endif>Medium</option>
                                    <option value="Low" @if ($reply['priority'] == 'Low') selected @endif>Low</option>
                                </select>
                                @error('priority')
                                    {{ $message }}
                                @enderror
                            </div>
                            <div class="col-sm-12">
                                <input type='file' class="form-control mt-2" name="attachment" id="attachment"
                                    placeholder="Attachment">
                            </div>
                        </div>

                        <center>
                            <div class="btn btn-group">
                                <button type="submit" class="btn btn-success">Submit Reply</button>

                            </div>
                        </center>
                    </form>
                </div>
                <div class="tab-pane fade pt-2" id="addnote" role="tabpanel" aria-labelledby="profile-tab">
                    <form
                        action="{{ url()->signedRoute('post_ticket_reply_note', ['tid' => $reply['ticketid'], 'client' => $reply['userid'], 'com' => $com->company_id]) }}"
                        method="post" enctype="multipart/form-data">

                        @csrf
                        <textarea name="notemessage" id="notemessage" placeholder="write message"> </textarea>

                        <center>
                            <div class="btn btn-group">
                                <button type="submit" class="btn btn-success">Submit Note</button>

                            </div>
                        </center>
                    </form>


                    <div id="mynotes">

                    </div>

                </div>
            </div>
        </div>


        <div class="col-sm-12 p-5 mt-5 mb-5 table-responsive" style="background-color:white;">
            <table class="table table-bordered table-striped table-hover table-sm" id="{{$randTablId}}">
                <thead>
                    <tr>
                        <th>Product/Service</th>
                        <th>Amount</th>
                        <th>Recurring Amount</th>
                        <th>Billing Cycle</th>
                        <th>Signup Date</th>
                        <th>Next Due Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>

                    @if ($client != 0)
                        @php
                            $clientProducts = json_decode($clientProducts['response'], true);
                            $clientDomains=json_decode($clientDomains['response'],true);
                            $mainTable='';
                            $matched='';
                            /**============= Client Products  ===========*/
                            if($clientProducts['result']=='success'){
                            if(is_array($clientProducts['products'])){

                                foreach ($clientProducts['products']['product'] as $pkey => $pvalue){
                                    $param=array('serviceid' => $pvalue['id'], 'com' => $com->company_id);
                                    if($pvalue['id']==$serviceId){
                                        $matched=' <tr style="background: red;">
                                        <td>
                                            <a href="'. url()->signedRoute('product_details',$param) .'"
                                                target="_blank" style="color:black;">'.$pvalue['name'] .'-'. $pvalue['domain'].'</a>
                                        </td>
                                        <td>'.$pvalue['firstpaymentamount'] .'</td>
                                        <td>'. $pvalue['recurringamount'] .'</td>
                                        <td>'. $pvalue['billingcycle'].'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['regdate'])).'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['nextduedate'])) .'</td>
                                        <td>'. $pvalue['status'] .'</td></tr>';
                                    }else{
                                        $mainTable.=' <tr>
                                        <td>
                                            <a href="'. url()->signedRoute('product_details',$param) .'"
                                                target="_blank">'.$pvalue['name'] .'-'. $pvalue['domain'].'</a>
                                        </td>
                                        <td>'.$pvalue['firstpaymentamount'] .'</td>
                                        <td>'. $pvalue['recurringamount'] .'</td>
                                        <td>'. $pvalue['billingcycle'].'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['regdate'])).'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['nextduedate'])) .'</td>
                                        <td>'. $pvalue['status'] .'</td></tr>';
                                    }

                                }
                             }
                            }else{
                                $mainTable .=' <tr>
                                        <td colspan="8" align="center">
                                            '.$clientProducts['message'].'
                                        </td>';
                            }
                            /**============= End Client Products  ===========*/

                            /**============= Client Domain  ===========*/
                            if($clientDomains['result']=='success'){
                            if(is_array($clientDomains['domains'])){

                                foreach ($clientDomains['domains']['domain'] as $pkey => $pvalue){
                                    $param=array('serviceid' => $pvalue['id'], 'com' => $com->company_id);
                                    if($pvalue['id']==$serviceId){
                                        $matched=' <tr style="background: red;">
                                        <td>
                                            <a href="#"
                                                style="color:black;"> Domain'.'-'. $pvalue['domainname'].'</a>
                                        </td>
                                        <td>'.$pvalue['firstpaymentamount'] .'</td>
                                        <td>'. $pvalue['recurringamount'] .'</td>
                                        <td> </td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['regdate'])).'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['nextduedate'])) .'</td>
                                        <td>'. $pvalue['status'] .'</td></tr>';
                                    }else{
                                        $mainTable.=' <tr>
                                        <td>
                                            <a href="'. url()->signedRoute('product_details',$param) .'"
                                                target="_blank"> Domain'.'-'. $pvalue['domainname'].'</a>
                                        </td>
                                        <td>'.$pvalue['firstpaymentamount'] .'</td>
                                        <td>'. $pvalue['recurringamount'] .'</td>
                                        <td> </td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['regdate'])).'</td>
                                        <td>'. date('d/m/Y', strtotime($pvalue['nextduedate'])) .'</td>
                                        <td>'. $pvalue['status'] .'</td></tr>';
                                    }

                                }

                             }
                            }else{
                                $mainTable .=' <tr>
                                        <td colspan="8" align="center">
                                            '.$clientProducts['message'].'
                                        </td>';
                            }
/**============= End Client Domain  ===========*/
                            echo $matched.$mainTable;
                        @endphp
                    @endif
                </tbody>
            </table>
        </div>
      <div id='replyid'></div>
    </div>

@includeIf('tpl.editor');
<script>
new Editor({
    element: document.getElementById("message")
});
new Editor({
    element: document.getElementById("notemessage")
});
</script>

@endsection

@push('script')


<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script type="module" src="https://md-block.verou.me/md-block.js"></script>
<script>
var delay = 1;
    setTimeout("replyes()", delay * 500);


function datatableme(){

    $('#{{$randTablId}}').DataTable( {
    retrieve: true,
    ordering: false
} );
}
        setTimeout(datatableme(), 500)

    </script>

    <script>
        function replyes() {
            startWaiting();
            var url = "{{route('get_ticket_reply')}}";
            var tid = $('#tid').val();
            var company = $('#company').val();

            fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-type': 'application/json',
                        'X-CSRF-TOKEN': $('input[name="_token"]').val()
                    },
                    body: JSON.stringify({
                        tid: tid,
                        company:company
                    })
                }).then((response) => response.json())
                .then((data) => {
                    console.log(data);
                    document.getElementById('replyid').innerHTML=data.reply;
                    document.getElementById('mynotes').innerHTML=data.note;
                    document.getElementById('totalnote').innerHTML=data.totalnote;
                    closeAlert();
                })
        }

        function updateTicket() {
            startWaiting();
            var url = "{{route('update_ticket_status_json')}}";
            var tid = $('#tid').val();
            var company = $('#company').val();
            var update_status = $('#update_status').val();
            if(update_status==""){
                alert("Status Is Required");
                return false;
            }

            fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-type': 'application/json',
                        'X-CSRF-TOKEN': $('input[name="_token"]').val()
                    },
                    body: JSON.stringify({
                        tid: tid,
                        company:company,
                        status:update_status
                    })
                }).then((response) => response.json())
                .then((data) => {
                    closeAlert();
                    alertMessage(data.status,data.message);
                })
        }

        function autoLogin() {
            var url = "";
            var smtp_name = $('#smtp_name').val();
            var smtp_domain = document.getElementById("smtp_domain").innerText;
            let smtp_url = smtp_name + smtp_domain;

            if (parseInt(smtp_name.length) <= 3) {
                document.getElementById('statusupdate').innerHTML = "";
                return false;
            }
            fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-type': 'application/json',
                        'X-CSRF-TOKEN': $('input[name="_token"]').val()
                    },
                    body: JSON.stringify({
                        smtp_url: smtp_url
                    })
                }).then((response) => response.json())
                .then((data) => {
                    document.getElementById('statusupdate').innerHTML = data.user_status;
                    document.getElementById('smtp').value = smtp_url;
                })
        }
    </script>
@endpush

