@extends('tpl.admin.layout')
@section('title', 'Company')

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Company Information</h5>

                    <!-- Vertical Form -->
                    <form class="row g-3" method="POST" enctype="multipart/form-data" action="{{route('company_store')}}">
                        @csrf
                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Name</label>
                            <input type="text" class="form-control" name="name" id="name" placeholder="eg:. PnServer">
                            @error('name')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputEmail4" class="form-label">url</label>
                            <input type="text" class="form-control" name="url" id="url" placeholder="eg:. https://secure.pnserver.com/">
                            @error('url')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputPassword4" class="form-label">Identifier</label>
                            <input type="text" class="form-control" name="identifier" id="identifier" placeholder="eg:. 3BpWuaaQt6TkQn8WiXMQZiOKW6aaQt6TkQn8">
                            @error('identifier')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputAddress" class="form-label">Secret Key</label>
                            <input type="text" class="form-control" name="secret" id="secret" placeholder="eg:. aaQt6TkQn8aaQt6TkQn8aaQt6TkQn8aaQt6TkQn8">
                            @error('secret')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputAddress" class="form-label">Support User <abbr title="whmcs support agent">?</label>
                            <input type="text" class="form-control" name="support_user" id="support_user" placeholder="eg:. pnserverusr">
                            @error('support_user')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="time_zone" class="form-label">Time Zone</label>
                            <input type="text" class="form-control" name="time_zone" id="time_zone" placeholder="eg:. UTC">
                            @error('time_zone')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12 bg-light">
                            <label for="signature" class="form-label">Signature </label>
                                <textarea name="signature" id="signature" placeholder="write message"></textarea>
                            @error('signature')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputAddress" class="form-label">Logo</label>
                            <input type="file" class="form-control" name="logo" id="logo">
                            @error('logo')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button type="reset" class="btn btn-secondary">Reset</button>
                        </div>
                    </form><!-- Vertical Form -->

                </div>
            </div>
        </div>
    </div>


    @includeIf('tpl.editor');
    <script>
    new Editor({
        element: document.getElementById("signature")
    });

    </script>

@endsection
