@extends('tpl.admin.layout')
@section('title', 'Company')

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Company Group</h5>

                    <!-- Vertical Form -->
                    <form class="row g-3" method="POST" enctype="multipart/form-data" action="{{route('cgroup_store')}}">
                        @csrf
                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Group Name</label>
                            <input type="text" class="form-control" name="name" id="name" placeholder="eg:. Group 1">
                            @error('name')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Company Name</label><br/>
                            @foreach ($company as $com)
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="company[]" value="{{$com->company_id}}" id="flexSwitchCheckDefault_{{$loop->iteration}}">
                                <label class="form-check-label" for="flexSwitchCheckDefault_{{$loop->iteration}}">{{$com->company_name}}</label>
                              </div>
                            @endforeach

                            @error('company')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button type="reset" class="btn btn-secondary">Reset</button>
                        </div>
                    </form><!-- Vertical Form -->

                </div>
            </div>
        </div>
    </div>
@endsection
