@extends('tpl.admin.layout')
@section('title', 'Company')

@section('content')
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Company List</h5>

                    <!-- Default Table -->
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">WHMCS User</th>
                                <th scope="col">URL</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($company as $com)
                            <tr>
                                <th scope="row">{{$loop->iteration}}</th>
                                <td>{{$com->company_name}}</td>
                                <td>{{$com->company_admin_user}}</td>
                                <td>{{$com->company_url}}</td>
                                <td>
                                    @php
                                        $url=url()->signedRoute('company_delete',$com->company_id);
                                    @endphp
                                    <div class="btn-group">
                                        <a href="{{url()->signedRoute('company_edit',$com->company_id)}}" class="btn btn-success btn-sm"><i class="bi bi-pencil-square"></i></a>
                                        <a href="#" onclick="deleteData('{{$url}}')" class="btn btn-danger  btn-sm"><i class="bi bi-trash2"></i></a>
                                    </div>

                                </td>
                            </tr>
                            @endforeach


                        </tbody>
                    </table>
                    <!-- End Default Table Example -->
                </div>
            </div>
        </div>
    </div>
@endsection
