<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />

        <meta name="author" content="afrakib.com" />
        <link rel="icon" href="{{ asset('assets/images/favicon.png') }}" type="image/x-icon" />
        <link rel="shortcut icon" href="{{ asset('assets/images/favicon.png') }}" type="image/x-icon" />
        <title>Email Verification</title>
        <link href="https://fonts.googleapis.com/css?family=Work+Sans:100,200,300,400,500,600,700,800,900" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" />
        <style>
            body {
                width: 650px;
                font-family: work-Sans, sans-serif;
                background-color: #f6f7fb;
                display: block;
            }
            a {
                text-decoration: none;
            }
            span {
                font-size: 14px;
            }
            p {
                font-size: 13px;
                line-height: 1.7;
                letter-spacing: 0.7px;
                margin-top: 0;
            }
            .text-center {
                text-align: center;
            }
        </style>
    </head>
    <body style="margin: 30px auto;">
        <table style="width: 100%;">
            <tbody>
                <tr>
                    <td>
                        <table style="background-color: #f6f7fb; width: 100%;">
                            <tbody>
                                <tr>
                                    <td>
                                        <table style="width: 650px; margin: 0 auto; margin-bottom: 30px;">
                                            <tbody>
                                                <tr>
                                                    <td><img src="{{ asset($data['company']->com_logo) }}" alt="" /></td>
                                                    <td style="text-align: right; color: #999;"><span>{{ $data['company']->com_default_slug }}</span></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table style="width: 650px; margin: 0 auto; background-color: #fff; border-radius: 8px;">
                                            <tbody>
                                                <tr>
                                                    <td style="padding: 30px;">
                                                        <p>Dear {{ $data['name'] }},</p>
                                                        <p>Thank you for creating a {{$data['company']->com_title}} account. Please review this email in its entirety as it contains important information.</p>
                                                        <b><h4>Logging In</h4></b>
                                                        <p>You can access our client area at {{ $data['url'] }}<br/>
                                                            You will need your email address and the password you chose during signup to login.<br/>
                                                            If you created an account as part of placing a new order with us, you will shortly receive an order confirmation email.
                                                        </p>
                                                        <p>We're sending you this email beacuse you registered a account.</p>
                                                        <h4 style="font-weight: 600;">Login Information</h4>
                                                        <p>
                                                    Username: {{ $data['username'] }} <br/>
                                                    Password: {{ $data['password'] }}
                                                        </p>
                                                        <p>You are receiving this email because you recently created an account. If you did not do this, please contact us.</p>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>

                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
    </body>
</html>
