@extends('tpl.admin.layout')
@section('title', 'Create Role')

@section('content')

<style>
    .inputGroup {
        background-color: rgb(10, 128, 92);
        display: block;
         margin: 5px 0;
        position: relative;
        border-radius: 5px;

    }

    .inputGroup label {
        padding:5px;
        width: auto;
        display: block;
        text-align: left;
        color: #ffffff;
        cursor: pointer;
        position: relative;
        z-index: 2;
        transition: color 200ms ease-in;
        overflow: hidden;
    }

    .inputGroup label:before {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        content: "";
        background-color: #5562eb;
        position: absolute;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%) scale3d(1, 1, 1);
        transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
        opacity: 0;
        z-index: -1;
    }

    .inputGroup label:after {
        width: 15px;
        height: 15px;
        content: "";
        border: 2px solid #D1D7DC;
        background-color: #fff;
        background-image: url("data:image/svg+xml,%3Csvg width='32' height='32' viewBox='0 0 32 32' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M5.414 11L4 12.414l5.414 5.414L20.828 6.414 19.414 5l-10 10z' fill='%23fff' fill-rule='nonzero'/%3E%3C/svg%3E ");
        background-repeat: no-repeat;
        background-position: 2px 3px;
        border-radius: 50%;
        z-index: 2;
        position: absolute;
        right: 30px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        transition: all 200ms ease-in;
    }

    .inputGroup input:checked~label {
        color: #fff;
        border-radius: 5px;
    }

    .inputGroup input:checked~label:before {
        transform: translate(-50%, -50%) scale3d(56, 56, 1);
        opacity: 1;
    }

    .inputGroup input:checked~label:after {
        background-color: #54E0C7;
        border-color: #54E0C7;
    }

    .inputGroup input {
        width: 32px;
        height: 32px;
        order: 1;
        z-index: 2;
        position: absolute;
        right: 30px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        visibility: hidden;
    }
</style>

    <div class="row mt-4">

        <div class="col-lg-12">

            @if (session()->has('msg'))
                <div class="alert alert-warning" role="alert">
                    {{ session()->get('msg') }}
                </div>
            @endif

            <form id="form" action="{{ route('role_store') }}" method="POST" class="form-horizontal">
                @csrf

                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                        </div>

                        <h2 class="card-title"><a href="{{ route('role_list') }}" class="btn btn-primary btn-sm"><i
                                    class="fas fa-arrow-left"></i> Back To list</a></h2>

                    </header>
                    <div class="card-body">
                        <input type="text" name="rolename" class="form-control" value="" placeholder="Role Name"
                            required>


                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <table class="table table-bordered mt-2">
                            <thead>
                                <tr>
                                    <th>sn</th>
                                    <th>Module Name</th>
                                    <th>Action <input type="checkbox" id="checkAll"> Check All</th>
                                    <th>Menu Name</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $counter = 1;
                                @endphp
                                @foreach ($module as $mod)
                                    @php
                                        $permission = $permissions->where('model_id', $mod->rmodel_id);
                                    @endphp

                                    <tr>
                                        <td>{{ $counter++ }}</td>
                                        <td>
                                            {{ ucwords(str_replace('_', ' ', $mod->rmodel_name)) }}</td>
                                        <td>
                                            @foreach ($permission as $permi)
                                                <div class="inputGroup">
                                                    <input type="checkbox" id="p{{ $permi->rpermission_id }}"
                                                        name="modulePermission{{ $mod->rmodel_id }}[]"
                                                        value="{{ $permi->rpermission_id }}">
                                                    <label
                                                        for="p{{ $permi->rpermission_id }}">{{ ucwords(str_replace('.', ' ', $permi->rpermission_name)) }}</label>
                                                </div>
                                            @endforeach
                                        </td>
                                        <td>
                                            @php
                                                $activeMenu = $menu->where('model_id', $mod->rmodel_id);
                                            @endphp
                                            @foreach ($activeMenu as $mn)
                                                <div class="inputGroup">
                                                    <input type="checkbox" id="m{{ $mn->rsmenu_id }}"
                                                        name="moduleMenu{{ $mod->rmodel_id }}[]"
                                                        value="{{ $mn->rsmenu_id }}">
                                                    <label
                                                        for="m{{ $mn->rsmenu_id }}">{{ ucwords(str_replace('.', ' ', $mn->rsmenu_name)) }}</label>
                                                </div>
                                            @endforeach
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                    <footer class="card-footer">
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button type="reset" class="btn btn-default">Reset</button>
                            </div>
                        </div>
                    </footer>
                </section>
            </form>
        </div>

    </div>

@endsection

@push('script')
    <script>
        $(document).ready(function() {
            setTimeout(function() {
                $(".alert").alert('close');
            }, 2000);
        });
        $("#checkAll").click(function() {
            $('input:checkbox').not(this).prop('checked', this.checked);
        });
    </script>
@endpush()
