@extends('tpl.admin.layout')
@section('title', 'Menu List')

@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.2/css/dataTables.bootstrap5.min.css">
@endpush

@section('content')

    <div class="row mt-4">

        <div class="col-lg-12">

            @if (session()->has('msg'))
                <div class="alert alert-warning" role="alert">
                    {{ session()->get('msg') }}
                </div>
            @endif

            <div class="row">
                <div class="col">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                <a href="#" class="card-action card-action-toggle" data-card-toggle></a>

                            </div>

                            <h2 class="card-title">
                                <a href="{{ route('menu_create') }}" class="btn btn-primary btn-sm"><i
                                        class="fas fa-plus"></i> Add Menu</a>
                            </h2>
                        </header>
                        <div class="card-body">

                            <table class="table table-bordered table-striped mb-0" id="amenu_list">

                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Menu Name</th>
                                        <th>Route</th>
                                        <th>Slug</th>
                                        <th>Order</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $sn = 1;
                                    $parent_menu = $menu->where('rsmenu_parentid', 0);
                                    ?>
                                    @foreach ($parent_menu as $prod)
                                        <tr>
                                            <td>{{ $sn++ }}</td>
                                            <td>{{ $prod->rsmenu_name }}</td>
                                            <td>{{ $prod->rsmenu_route }}</td>
                                            <td>{{ $prod->rsmenu_slug }}</td>
                                            <td>{{ $prod->rsmenu_order }}</td>

                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ url()->signedRoute('menu_edit', $prod->rsmenu_id) }}"
                                                        class="btn btn-primary">Edit</a>
                                                    <a href="{{ url()->signedRoute('menu_delete', $prod->rsmenu_id) }}"
                                                        onclick="return confirm('Are you sure delete this')"
                                                        class="btn btn-danger">Delete</a>
                                                </div>

                                            </td>
                                        </tr>
                                        @php $child_menu=$menu->where('rsmenu_parentid',$prod->rsmenu_id) @endphp
                                        @if (!empty($child_menu))
                                            @foreach ($child_menu as $cm)
                                                <tr>
                                                    <td>{{ $sn++ }}</td>
                                                    <td>--{{ $cm->rsmenu_name }}</td>
                                                    <td>{{ $cm->rsmenu_route }}</td>
                                                    <td>{{ $cm->rsmenu_slug }}</td>
                                                    <td>{{ $cm->rsmenu_order }}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="{{ url()->signedRoute('menu_edit', $cm->rsmenu_id) }}"
                                                                class="btn btn-primary">Edit</a>
                                                            <a href="{{ url()->signedRoute('menu_delete', $cm->rsmenu_id) }}"
                                                                onclick="return confirm('Are you sure delete this')"
                                                                class="btn btn-danger">Delete</a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
            </div>
        </div>

    </div>

@endsection

@push('script')
    <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.2/js/dataTables.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            setTimeout(function() {
                $(".alert").alert('close');
            }, 3000);
            $('#amenu_list').DataTable();
        });
    </script>
@endpush
