@extends('tpl.admin.layout')
@section('title', 'Role List')

@section('content')

    <div class="row mt-4">

        <div class="col-lg-12">

            @if (session()->has('msg'))
                <div class="alert alert-warning" role="alert">
                    {{ session()->get('msg') }}
                </div>
            @endif

            <div class="row">
                <div class="col">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                            </div>

                            <h2 class="card-title">
                                <a href="{{ route('role_create') }}" class="btn btn-primary btn-sm"><i
                                        class="fas fa-plus"></i> Add Role</a>
                            </h2>
                        </header>
                        <div class="card-body">

                            <table class="table table-bordered table-striped mb-0" id="productList">

                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Role Name</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $sn = 1; ?>
                                    @foreach ($role as $prod)
                                        <tr>
                                            <td>{{ $sn++ }}</td>
                                            <td>{{ $prod->role_name }}</td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ url()->signedRoute('role_edit', $prod->role_id) }}"
                                                        class="btn btn-primary">Edit</a>
                                                    <a href="{{ url()->signedRoute('role_delete', $prod->role_id) }}"
                                                        onclick="return confirm('Are you sure delete this')"
                                                        class="btn btn-danger">Delete</a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
            </div>
        </div>

    </div>

@endsection

@section('footer')
    <script>
        $(document).ready(function() {
            setTimeout(function() {
                $(".alert").alert('close');
            }, 3000);
            $('#productList').DataTable({
                responsive: true,
            });
        });
    </script>
@endsection
