@extends('tpl.admin.layout')
@section('title', 'Update Menu')

@section('content')

    <div class="row mt-4">

        <div class="col-lg-12">

            @if (session()->has('msg'))
                <div class="alert alert-warning" role="alert">
                    {{ session()->get('msg') }}
                </div>
            @endif

            <form id="form" action="{{ url()->signedRoute('menu_update',$id) }}" method="POST" class="form-horizontal">
                @csrf
                @method('PUT')
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                        </div>

                        <h2 class="card-title"><a href="{{ route('menu_list') }}" class="btn btn-primary btn-sm"><i
                                    class="fas fa-arrow-left"></i> Back To list</a></h2>

                    </header>
                    <div class="card-body">
                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Menu Name <span
                                    class="required">*</span></label>
                            <div class="col-sm-9">
                                <input type="text" name="menu_name" class="form-control"
                                    value="{{ $menu->rsmenu_name }}" placeholder="eg.: Menu" required="1">
                                @error('menu_name')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <input type="hidden" name="menu_id" value="{{ Request::segment(3) }}">

                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Menu Slug <span
                                    class="required">*</span></label>
                            <div class="col-sm-9">
                                <input type="text" name="menu_slug" class="form-control"
                                    placeholder="eg.: menu/create/store" value="{{ $menu->rsmenu_slug }}" required="1">
                                @error('menu_slug')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Menu Route <span
                                    class="required">*</span></label>
                            <div class="col-sm-9">
                                <input type="text" name="menu_route" class="form-control" placeholder="eg.: create_menu"
                                    value="{{ $menu->rsmenu_route }}" required="1">
                                @error('menu_route')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Parent Menu</label>
                            <div class="col-sm-9">
                                <select  name="parent_menu" id="parent_menu" class="form-control">
                                    <option value="0"> Select Parent </option>
                                    @foreach ($parent_menu as $pm)
                                        <option value="{{ $pm->rsmenu_id }}"
                                            @if ($menu->rsmenu_parentid == $pm->rsmenu_id) @selected(true) @endif>
                                            {{ $pm->rsmenu_name }} </option>
                                    @endforeach
                                </select>
                                @error('parent_menu')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Menu Order <span
                                    class="required">*</span></label>
                            <div class="col-sm-9">
                                <input type="text" name="menu_order" class="form-control" placeholder="eg.: 0"
                                    value="{{ $menu->rsmenu_order }}" required="1">
                                @error('menu_order')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Menu Icon</label>
                            <div class="col-sm-9">
                                <input type="text" name="menu_icon" class="form-control" placeholder="eg.: bx bx-cart-alt"
                                    value="{{ $menu->rsmenu_icon }}" >
                                @error('menu_icon')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row pb-3">
                            <label class="col-sm-2 control-label text-sm-end pt-2">Module <span
                                class="required">*</span></label>
                            <div class="col-sm-9">
                                <select name="module_name" id="module_name" class="form-control" required="1">
                                    <option value=""> Select Module </option>
                                    @foreach ($module as $mdl)
                                        <option value="{{ $mdl->rmodel_id }}" @if($menu->model_id==$mdl->rmodel_id) @selected(true) @endif> {{ $mdl->rmodel_name }} </option>
                                    @endforeach
                                </select>
                                @error('module_name')
                                    <span class="required">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                    </div>
                    <footer class="card-footer">
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button type="reset" class="btn btn-default">Reset</button>
                            </div>
                        </div>
                    </footer>
                </section>
            </form>
        </div>

    </div>

@endsection

@push('script')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    $('#module_name').select2();
    $('#parent_menu').select2();
    $(document).ready(function() {
        setTimeout(function() {
            $(".alert").alert('close');
        }, 2000);
    });
</script>

@endpush
