<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>@yield('title')</title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <meta name="token" content="{{csrf_token()}}">

    @includeIf('tpl.admin.header')

    @stack('css')

    <!-- =======================================================
  * Template Name: NiceAdmin - v2.3.1
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
    <link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet'>
</head>

<body>

    <!-- ======= Header Nav======= -->
    @includeIf('tpl.admin.header_nav')

    <!-- ======= Sidebar ======= -->
    @includeIf('tpl.admin.sidebar')
    <!-- End Sidebar-->

    <main id="main" class="main">

        @if (session()->has('success'))
            <div class="alert alert-success bg-success text-light border-0 alert-dismissible fade show" id="alert"
                role="alert">
                {{ session()->get('success') }}
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" id="alert"
                role="alert">
                {{ session()->get('error') }}
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        @endif

        @section('content')
        @show

    </main><!-- End #main -->

    <!-- ======= Footer ======= -->

    @includeIf('tpl.admin.footer')

</body>

</html>

<script>
    $("#alert").fadeTo(3000, 700).slideUp(700, function() {
        $("#alert").slideUp(700);
    });

    function startWaiting() {
        let timerInterval
        Swal.fire({
            title: 'Wait',
            html: 'Please Wait Work In Progress',
            timer: 5000,
            timerProgressBar: true,
            didOpen: () => {
                Swal.showLoading();

            },
            willClose: () => {
                clearInterval(timerInterval)
            }
        });
        Swal.DismissReason.timer;
    }

    function closeAlert() {
        swal.close();
    }
</script>

@stack('script')
