<!doctype html>
<html>

<head>
    <meta charset='utf-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1'>
    <title>{{config('app.name')}}</title>
    @include('userlogin.partial.header')
</head>

<body className='snippet-body'>
    <div class="wrapper">
        <div class="logo">
            <img src="{{ asset('logo/logo.png') }}" alt="" class="img-fluid">
        </div>
        <div class="text-center mt-4 name">
            {{config('app.name')}}
        </div>
        <form class="p-3 mt-3" action="{{route('checkLogin')}}" method="post">
            @csrf
            <div class="form-field d-flex align-items-center">
                <span class="far fa-user"></span>
                <input type="text" name="username" id="username" placeholder="Username" autocomplete="off" required>
            </div>
            <div class="form-field d-flex align-items-center">
                <span class="fas fa-key"></span>
                <input type="password" name="password" id="password" placeholder="Password" autocomplete="off" required>
            </div>
            <div class="d-flex">
                <input type="checkbox" name="remember_me" id="remember_me" value="true"> Remember Me
            </div>
            @if(session()->has('failed'))
                <p style="color:red;">{{session()->get('failed')}}</p>
            @endif
            @if(session()->has('success'))
                <p style="color:green;">{{session()->get('success')}}</p>
            @endif
            <button class="btn mt-3" type="submit">Login</button>
        </form>
        <div class="text-left fs-6">
            <a href="{{route('forgetpassword')}}">Forget password?</a>
        </div>
    </div>

    @include('userlogin.partial.footer')

</body>

</html>
