@extends('tpl.admin.layout')
@section('title', 'Update User')

@section('content')
    <div class="row">
        <div class="col-sm-12">

            @if (session()->has('msg'))
                <div class="alert alert-warning" role="alert">
                    {{ session()->get('msg') }}
                </div>
            @endif

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Create User</h5>

                    <!-- Vertical Form -->
                    <form class="row g-3" method="POST" enctype="multipart/form-data"
                        action="{{ url()->signedRoute('user_update', $id) }}">
                        @csrf
                        @method('PUT')
                        <div class="col-6">
                            <label for="name" class="form-label">Name <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name"
                                placeholder="eg:. A.F.Rakib" value="{{ $user->user_fullname }}" required>
                            @error('name')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="username" class="form-label">Username <span class="required">*</span></label>
                            <input type="text" class="form-control" name="username" id="username"
                                placeholder="eg:. devrakib" value="{{ $user->user_name }}" required>
                            @error('username')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="email" class="form-label">Email <span class="required">*</span></label>
                            <input type="email" class="form-control" name="email" id="email"
                                placeholder="eg:. rakib@example.com" value="{{ $user->user_email }}" required>
                            @error('email')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="phone" class="form-control" name="phone" id="phone"
                                placeholder="eg:. 01xxxxxxxxx" value="{{ $user->user_phone }}">
                            @error('phone')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="password" class="form-label">Password </label>

                            <div class="input-group">
                                <input type="password" class="form-control" id="password" name="password"
                                    placeholder="o&amp;@pPhK*!^nao" onkeypress="strongPassword(this.value)">
                                <div class="btn-group">
                                    <button class="btn btn-secondary" type="button" id="ibutton"
                                        onclick="passwordShow()">show</button>
                                    <button class="btn btn-primary" type="button" onclick="genPassword()"
                                        title="password">gen</button>
                                </div>
                            </div>
                            <span id="passwordStrength" style="color: green;"></span>

                            @error('password')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        @php
    $companyUser=json_decode($user->user_company);
@endphp
                        <div class="col-6">
                            <label for="group" class="form-label">Company <span class="required">*</span></label>
                            <select class="form-control" name="company[]" id="company" multiple required>
                                <option value="">Choose One</option>
                                @foreach ($company as $com)
                                @if(is_array($companyUser))
                                <option value="{{ $com->company_id }}" @php
                                    echo (array_search($com->company_id,$companyUser)!='')? 'selected':'';
                                @endphp>
                                    {{ $com->company_name }}</option>
                                @else
                                <option value="{{ $com->company_id }}"> {{ $com->company_name }}</option>
                                @endif

                                @endforeach
                            </select>
                            @error('company')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="role" class="form-label">User Role <span class="required">*</span></label>
                            <select class="form-control" name="role" id="role" required>
                                <option value="">Choose One</option>
                                @foreach ($role as $rl)
                                    <option value="{{ $rl->role_id }}" @if ($user->user_role == $rl->role_id) selected @endif>
                                        {{ $rl->role_name }}</option>
                                @endforeach
                            </select>
                            @error('role')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="status" class="form-label">User Status <span class="required">*</span></label>
                            <select class="form-control" name="status" id="status" required>
                                <option value="active" @if ($user->user_status == 'active') selected @endif>Active</option>
                                <option value="inactive" @if ($user->user_status == 'inactive') selected @endif>InActive
                                </option>
                            </select>
                            @error('status')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-6">
                            <label for="address" class="form-label">Address </label>
                            <input type="text" class="form-control" name="address" id="address"
                                placeholder="eg:. address" value="{{ $user->user_address }}">
                            @error('address')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button type="reset" class="btn btn-secondary">Reset</button>
                        </div>
                    </form><!-- Vertical Form -->

                </div>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $('#role').select2();
        $('#company').select2({
            placeholder: 'Choose One Company',
        });

        $(document).ready(function() {
            setTimeout(function() {
                $(".alert").alert('close');
            }, 2000);
        });



        function passwordShow() {
            document.getElementById("password").setAttribute('type', 'text');
            document.getElementById("ibutton").setAttribute('onclick', 'passwordHide()');
            document.getElementById("ibutton").innerHTML = 'hide';
        }

        function passwordHide() {
            document.getElementById("password").setAttribute('type', 'password');
            document.getElementById("ibutton").setAttribute('onclick', 'passwordShow()');
            document.getElementById("ibutton").innerHTML = 'show';
        }

        function genPassword() {
            var chars = "0123456789abcdefghijklmnopqrstuvwxyz!@#$%^&*()ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            var passwordLength = 15;
            var password = "";
            for (var i = 0; i <= passwordLength; i++) {
                var randomNumber = Math.floor(Math.random() * chars.length);
                password += chars.substring(randomNumber, randomNumber + 1);
            }
            document.getElementById("password").value = password;
            strongPassword(password);
        }

        function strongPassword(password) {

            if (password.length === 0) {
                document.getElementById("passwordStrength").innerHTML = "";
                return;
            }
            // Create an array and push all possible values that you want in password
            var matchedCase = new Array();
            matchedCase.push("[$@$!%*#?&]"); // Special Charector
            matchedCase.push("[A-Z]"); // Uppercase Alpabates
            matchedCase.push("[0-9]"); // Numbers
            matchedCase.push("[a-z]"); // Lowercase Alphabates

            // Check the conditions
            var ctr = 0;
            for (var i = 0; i < matchedCase.length; i++) {
                if (new RegExp(matchedCase[i]).test(password)) {
                    ctr++;
                }
            }
            // Display it
            var color = "";
            var strength = "";
            switch (ctr) {
                case 0:
                case 1:
                case 2:
                    strength = "Very Weak Password";
                    color = "red";
                    break;
                case 3:
                    strength = "Medium Password";
                    color = "orange";
                    break;
                case 4:
                    strength = "Strong Password";
                    color = "green";
                    break;
            }
            document.getElementById("passwordStrength").innerHTML = strength;
            document.getElementById("passwordStrength").style.color = color;
        }

        function copyClipBoard(boardId) {
            var copyText = document.getElementById(boardId);
            copyText.select();
            copyText.setSelectionRange(0, 99999); // For mobile devices
            navigator.clipboard.writeText(copyText.value);

        }


        function checkUserName() {
            var url = "";
            var smtp_name = $('#smtp_name').val();
            var smtp_domain = document.getElementById("smtp_domain").innerText;
            let smtp_url = smtp_name + smtp_domain;

            if (parseInt(smtp_name.length) <= 3) {
                document.getElementById('statusupdate').innerHTML = "";
                return false;
            }
            fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-type': 'application/json',
                        'X-CSRF-TOKEN': $('input[name="_token"]').val()
                    },
                    body: JSON.stringify({
                        smtp_url: smtp_url
                    })
                }).then((response) => response.json())
                .then((data) => {
                    document.getElementById('statusupdate').innerHTML = data.user_status;
                    document.getElementById('smtp').value = smtp_url;
                })
        }
    </script>
@endpush
