@extends('tpl.admin.layout')
@section('title', 'Company')

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">User Group</h5>

                    <!-- Vertical Form -->
                    <form class="row g-3" method="POST" enctype="multipart/form-data" action="{{route('cgroup_store')}}">
                        @csrf
                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Group Name</label>
                            <input type="text" class="form-control" name="name" id="name" placeholder="eg:. Group 1">
                            @error('name')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Company Group</label><br/>
                            <select name="group" id="group" class="form-control">
                                <option value="">Choose One</option>
                                @foreach ($cgroup as $com)
                                    <option value="{{$com->cgroup_id}}">{{$com->cgroup_name}}</option>
                                @endforeach
                            </select>
                            @error('group')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label for="inputNanme4" class="form-label">Users</label><br/>
                            <select name="group" id="group" class="form-control">
                                <option value="">Choose One</option>
                                @foreach ($cgroup as $com)
                                    <option value="{{$com->cgroup_id}}">{{$com->cgroup_name}}</option>
                                @endforeach
                            </select>
                            @error('group')
                                <p class="text-danger">{{$message}}</p>
                            @enderror
                        </div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button type="reset" class="btn btn-secondary">Reset</button>
                        </div>
                    </form><!-- Vertical Form -->

                </div>
            </div>
        </div>
    </div>
@endsection
