@extends('tpl.admin.layout')
@section('title', 'User List')
@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.2/css/dataTables.bootstrap5.min.css">
@endpush
@section('content')
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">User List</h5>

                    <!-- Default Table -->
                    <table class="table table-striped" id="userlist">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">Username</th>
                                <th scope="col">Email</th>
                                <th scope="col">Status</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($userList as $usr)
                            <tr>
                                <th scope="row">{{$loop->iteration}}</th>
                                <td>{{$usr->user_fullname}}</td>
                                <td>{{$usr->user_name}}</td>
                                <td>{{$usr->user_email}}</td>
                                <td>{{ucfirst($usr->user_status)}}</td>
                                <td>

                                    <div class="btn-group">
                                        <a href="{{url()->signedRoute('user_edit',$usr->user_id)}}" class="btn btn-success btn-sm"><i class="bi bi-pencil-square"></i></a>
                                        <a href="{{url()->signedRoute('user_delete',$usr->user_id)}}"  class="btn btn-danger  btn-sm" onclick="return confirm('Are You Sure Delete This User ?')"><i class="bi bi-trash2"></i></a>
                                    </div>

                                </td>
                            </tr>
                            @endforeach


                        </tbody>
                    </table>
                    <!-- End Default Table Example -->
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.2/js/dataTables.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            setTimeout(function() {
                $(".alert").alert('close');
            }, 3000);
            $('#userlist').DataTable();
        });
    </script>
@endpush
