<?php

use App\Http\Controllers\AgentsJob\Clients;
use App\Http\Controllers\AgentsJob\Tickets;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard;
use App\Http\Controllers\Users;

/**============= User/Agent Backend =========================== */
Route::group(['middleware' => 'auth:web'], function () {
    Route::controller(Dashboard::class)->group(function () {
        Route::get('agent/dashboard', 'index')->name('agentdashboard');
    });

    Route::controller(Tickets::class)->group(function(){
        Route::get('ticket','index')->name('ticket');
        Route::get('ticket/count','ticketCounts')->name('ticket_counts');
        Route::get('ticket/pending','ticketPending')->name('ticket_pending');
        Route::get('all-ticket','allTicket')->name('all_ticket');
        Route::get('ticket/reply/{tid}/{client}/{com}','ticketReply')->name('ticket_reply')->middleware('signed');
        Route::post('ticket/postreply/{tid}/{com}','postTicketReply')->name('post_ticket_reply')->middleware('signed');
        Route::post('ticket/getpostreply','getJsonNoteReply')->name('get_ticket_reply');
        Route::post('ticket/postreplynote/{tid}/{com}','ticketReplyNote')->name('post_ticket_reply_note')->middleware('signed');
        Route::post('ticket/updateticketstatus','updateTicketStatus')->name('update_ticket_status_json');
        Route::get('ticket/closedticketreply/{tid}/{com}','ClosedTicketStatus')->name('closed_ticket_status')->middleware('signed');
    });

    Route::controller(Clients::class)->group(function(){
        Route::get('client/productdetails/{serviceid}/{com}','productDetails')->name('product_details')->middleware('signed');
        Route::get('client/autologin/{server}/{port}/{cpuser}/{cppass}','cPanelAutoLoin')->name('cpanel_autologin')->middleware('signed');
        Route::get('client/productsuspend/{serviceid}/{com}/{reason}','productSuspend')->name('product_suspend');
        Route::get('client/productunsuspend/{serviceid}/{com}','productUnsuspend')->name('product_unsuspend');
        Route::get('client/productchangepwd/{serviceid}/{com}/{pass}','productChangePwd')->name('product_changepwd');
        Route::get('client/productcreate/{serviceid}/{com}','productCreate')->name('product_create');
        Route::get('client/productterminate/{serviceid}/{com}','productTerminate')->name('product_terminate');
    });

    Route::get('update/signature',[Users::class,'signature'])->name('signature');
    Route::post('update/signature/store',[Users::class,'signatureStore'])->name('signature_store');

});
