<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

/**========== Agent Login ================== */
Route::controller(\App\Http\Controllers\APIs\AgentAuthController::class)->group(function () {
    Route::post('getagenttoken', 'getToken');
    Route::get('revocketoken', 'destroyToken');
});
/**========== Admin Login ================== */
Route::controller(\App\Http\Controllers\APIs\AdminAuthController::class)->group(function () {
    Route::post('gettoken', 'getToken');
    Route::get('revocketoken', 'destroyToken');
});

/**======== Agent Ticket Related Details ============== */
Route::middleware('auth:sanctum')->group(function () {
    Route::controller(\App\Http\Controllers\APIs\AgentsJob\ApiTickets::class)->group(function () {
        Route::get('alltickets', 'allTicket');
        Route::get('ticketpending', 'ticketPending');
        Route::get('ticket/reply/{tid}/{client}/{com}', 'ticketReply');
        Route::post('ticket/postreply/{tid}/{com}', 'postTicketReply');
        Route::post('ticket/updateticketstatus', 'updateTicketStatus');
        Route::post('ticket/getpostreply', 'getJsonNoteReply');
        // Route::post('ticket/getpostreply','getJsonNoteReply')->name('get_ticket_reply');
        // Route::post('ticket/postreplynote/{tid}/{com}','ticketReplyNote')->name('post_ticket_reply_note')->middleware('signed');

        // Route::get('ticket/closedticketreply/{tid}/{com}','ClosedTicketStatus')->name('closed_ticket_status')->middleware('signed');
    });
});

Route::middleware('auth:sanctum')->group(function () {

    //Run All Authenticated Data
    Route::controller(\App\Http\Controllers\APIs\AdminAuthController::class)->group(function () {
        Route::get('revocketoken', 'destroyToken');
        Route::post('company', 'store');
    });
});
