<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AddonControl;
use App\Http\Controllers\AdminLogin;
use App\Http\Controllers\Dashboard;
use App\Http\Controllers\UserLogin;

use App\Http\Controllers\Company\Company;
use App\Http\Controllers\Company\CompanyGroup;
use App\Http\Controllers\Role;
use App\Http\Controllers\UserGroup;
use App\Http\Controllers\Users;

Route::get('/plugins', [AddonControl::class, 'index'])->name('plugins_upload');
Route::post('plugins/upload', [AddonControl::class, 'store'])->name('plugins_store');
Route::get('/template', [AddonControl::class, 'uploadTemplate'])->name('template_upload');
Route::post('template/upload', [AddonControl::class, 'templateUpload'])->name('template_store');
/**=========== Agent Login =============== */
Route::controller(UserLogin::class)->group(function () {
    Route::get('/', 'index')->name('login');
    Route::post('checkLogin', 'checkLogin')->name('checkLogin');
    Route::get('forgetpassword', 'forgetPassword')->name('forgetpassword');
    Route::post('request-reset', 'sendResetEmail')->name('send_reset_email');
    Route::get('resetpasswordnow', 'passwordResetNow')->name('password_reset_now');
    Route::post('confirmpasswordreset', 'confirmPasswordReset')->name('confirm_password_reset');
    Route::get('logout', 'logout')->name('logout');
});

/**=========== Admin Login =============== */
Route::group(['prefix' => 'admin'], function () {
    Route::controller(AdminLogin::class)->group(function () {
        Route::get('cssalogin', 'index')->name('admin_login');
        Route::post('checkLogin', 'checkLogin')->name('admin_checkLogin');
        Route::get('forgetpassword', 'forgetPassword')->name('admin_forgetpassword');
        Route::post('request-reset', 'sendResetEmail')->name('admin_send_reset_email');
        Route::get('resetpasswordnow', 'passwordResetNow')->name('admin_password_reset_now');
        Route::post('confirmpasswordreset', 'confirmPasswordReset')->name('admin_confirm_password_reset');
        Route::get('logout', 'logout')->name('admin_logout');
    });

    Route::group(['middleware' => 'auth:admin'], function () {
        Route::controller(Company::class)->group(function () {
            Route::get('company/list', 'index')->name('company_list');
            Route::get('company/create', 'create')->name('company_create');
            Route::post('company/store', 'store')->name('company_store');
            Route::get('company/edit/{id}', 'edit')->name('company_edit')->middleware('signed');
            Route::put('company/update/store/{id}', 'update')->name('company_update')->middleware('signed');
            Route::delete('company/delete/{id}', 'destroy')->name('company_delete')->middleware('signed');
        });

        Route::controller(CompanyGroup::class)->group(function () {
            Route::get('cgroup/list', 'index')->name('cgroup_list');
            Route::get('cgroup/create', 'create')->name('cgroup_create');
            Route::post('cgroup/store', 'store')->name('cgroup_store');
            Route::get('cgroup/edit/{id}', 'edit')->name('cgroup_edit')->middleware('signed');
            Route::put('cgroup/update/store/{id}', 'update')->name('cgroup_update')->middleware('signed');
            Route::delete('cgroup/delete/{id}', 'destroy')->name('cgroup_delete')->middleware('signed');
        });

        Route::controller(Role::class)->group(function () {
            Route::get('role/list', 'roleList')->name('role_list');
            Route::get('role/create', 'roleCreate')->name('role_create');
            Route::post('role/store', 'roleStore')->name('role_store');
            Route::get('role/edit/{id}', 'roleEdit')->name('role_edit')->middleware('signed');
            Route::put('role/update/{id}', 'roleUpdate')->name('role_update')->middleware('signed');
            Route::get('role/delete/{id}', 'roleDelete')->name('role_delete')->middleware('signed');
            /**======= Menu add and Remove ============== */

            Route::get('menu/list', 'menuList')->name('menu_list');
            Route::get('menu/create', 'menuCreate')->name('menu_create');
            Route::post('menu/store', 'menuStore')->name('menu_store');
            Route::get('menu/edit/{id}', 'menuEdit')->name('menu_edit')->middleware('signed');
            Route::put('menu/update/{id}', 'menuUpdate')->name('menu_update')->middleware('signed');
            Route::get('menu/delete/{id}', 'deleteMenu')->name('menu_delete')->middleware('signed');
        });

        Route::controller(Users::class)->group(function () {
            Route::get('user/list', 'index')->name('user_list');
            Route::get('user/create', 'create')->name('user_create');
            Route::post('user/store', 'store')->name('user_store');
            Route::get('user/edit/{id}', 'edit')->name('user_edit')->middleware('signed');
            Route::put('user/update/{id}', 'update')->name('user_update')->middleware('signed');
            Route::get('user/delete/{id}', 'delete')->name('user_delete')->middleware('signed');
        });
    });
});

/**============= Admin Backend =========================== */
Route::group(['middleware' => 'auth:admin'], function () {
    Route::controller(Dashboard::class)->group(function () {
        Route::get('/admin/dashboard', 'admin')->name('dashboard');
    });
    Route::controller(UserGroup::class)->group(function () {
        Route::get('/admin/usergroup/create','create')->name('usergroup_create');
        Route::get('/admin/usergroup/store','store')->name('usergroup_store');
    });
});

include('agent.php');
